<?php

require_once 'includes/db_connect.php';
require_once 'core/routing.php';
require_once 'core/madr_router.php'; // where madr_terminate lives

echo "<pre>";

// Simulated transaction payload
$payload = [
    'reference'     => 'TEST-' . time(),
    'from_country'  => 'GH',
    'recipient'     => 'Test User',
    'phone'         => '254712345678', // Kenya number
    'amount'        => 10,
    'sender_name'   => 'MADR Test'
];

// Simulate Ghana → Kenya
$destinationCountry = 'KE';
$network = 'MPESA'; // Must match madr_networks table

echo "Testing GH → KE Route...\n\n";

$response = madr_terminate($destinationCountry, $network, $payload);

print_r($response);

echo "\nDone.";
