<?php
session_start();
include('includes/db_connect.php');
if(!isset($_SESSION['admin'])) header("Location: index.php");

// -----------------------------
// Handle Save / Update
// -----------------------------
if(isset($_POST['save'])){
    $msisdn = $_POST['msisdn'] ?: 'ALL';
    $daily = floatval($_POST['daily'] ?? 0);
    $cum = floatval($_POST['cumulative'] ?? 0);

    // Daily limit
    $conn->query("
        INSERT INTO msisdn_limits(msisdn, limit_type, max_amount)
        VALUES('$msisdn','DAILY',$daily)
        ON DUPLICATE KEY UPDATE max_amount=$daily
    ");

    // Cumulative limit
    $conn->query("
        INSERT INTO msisdn_limits(msisdn, limit_type, max_amount)
        VALUES('$msisdn','CUMULATIVE',$cum)
        ON DUPLICATE KEY UPDATE max_amount=$cum
    ");
}

// -----------------------------
// Fetch Limits
// -----------------------------
$limits_res = $conn->query("SELECT * FROM msisdn_limits ORDER BY msisdn, limit_type");

// Build a nested array for easy editing
$limits = [];
while($row = $limits_res->fetch_assoc()){
    $msisdn = $row['msisdn'];
    $type = $row['limit_type'];
    $limits[$msisdn][$type] = $row['max_amount'];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>MSISDN Limits - MADR</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/styles.css">
    <style>
        body { font-family: 'Inter', sans-serif; background:#f0f4f8; margin:0; }
        .main-content { margin-left:260px; padding:30px; transition:0.3s; }
        .card { background:#fff; border-radius:12px; padding:20px; margin-bottom:20px; box-shadow:0 5px 15px rgba(0,0,0,0.05); }
        table { width:100%; border-collapse:collapse; }
        th, td { padding:10px 12px; text-align:left; }
        th { background:#f3f4f6; }
        input[type="number"], input[type="text"] { width:100%; padding:6px 8px; border-radius:6px; border:1px solid #ccc; }
        button { padding:8px 14px; background:#0b1c2d; color:#fff; border:none; border-radius:6px; cursor:pointer; }
        button:hover { background:#142f4a; }
        @media(max-width:600px){ .main-content{margin-left:70px; padding:15px;} }
    </style>
</head>
<body>

<?php include('includes/mobex_sidebar.php'); ?>

<div class="main-content">
    <h2>Manage MSISDN Limits</h2>

    <!-- Add / Update Form -->
    <div class="card" style="margin-bottom:25px;">
        <form method="POST" style="display:flex;gap:10px;flex-wrap:wrap;">
            <input type="text" name="msisdn" placeholder="MSISDN (or ALL)" required>
            <input type="number" step="0.01" name="daily" placeholder="Daily Limit" required>
            <input type="number" step="0.01" name="cumulative" placeholder="Cumulative Limit" required>
            <button type="submit" name="save"><i class="fa fa-save"></i> Save</button>
        </form>
    </div>

    <!-- Existing Limits Table -->
    <div class="card">
        <table>
            <thead>
                <tr>
                    <th>MSISDN</th>
                    <th>Daily Limit</th>
                    <th>Cumulative Limit</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach($limits as $msisdn => $types): ?>
                <tr>
                    <form method="POST">
                        <td>
                            <input type="text" name="msisdn" value="<?= htmlspecialchars($msisdn) ?>" readonly>
                        </td>
                        <td>
                            <input type="number" step="0.01" name="daily" value="<?= $types['DAILY'] ?? 0 ?>" required>
                        </td>
                        <td>
                            <input type="number" step="0.01" name="cumulative" value="<?= $types['CUMULATIVE'] ?? 0 ?>" required>
                        </td>
                        <td>
                            <button type="submit" name="save"><i class="fa fa-edit"></i> Update</button>
                        </td>
                    </form>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>

</div>

<script>
    // Sidebar toggle (if collapsed)
    document.getElementById('toggleSidebar')?.addEventListener('click', function () {
        document.getElementById('sidebarMenu').classList.toggle('collapsed');
        document.querySelector('.main-content').classList.toggle('expanded');
    });
</script>

</body>
</html>
