<?php
session_start();
include('includes/db_connect.php');

// Redirect already logged-in admins
if(isset($_SESSION['admin'])) {
    header("Location: dashboard.php");
    exit;
}

$error = '';

if(isset($_POST['login'])){
    $username = $conn->real_escape_string($_POST['username']);
    $password = $_POST['password'];

    $row = $conn->query("SELECT * FROM admin_users WHERE username='$username' LIMIT 1")->fetch_assoc();

    if($row && password_verify($password, $row['password'])){
        $_SESSION['admin'] = [
            'id' => $row['id'],
            'username' => $row['username'],
            'role' => $row['role'],
            'full_name' => $row['full_name'],
            'email' => $row['email']
        ];
        header("Location: dashboard.php");
        exit;
    } else {
        $error = "❌ Invalid username or password";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Mobex ADR Admin Login</title>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
<style>
    /* Reset & base styles */
    * { margin:0; padding:0; box-sizing:border-box; font-family:'Inter', sans-serif; }
    body { background:#f0f4f8; display:flex; align-items:center; justify-content:center; height:100vh; }
    .login-container { background:#fff; padding:40px 50px; border-radius:12px; box-shadow:0 15px 30px rgba(0,0,0,0.1); width:100%; max-width:400px; }
    .login-container h2 { text-align:center; color:#1f2937; margin-bottom:25px; font-weight:700; }
    input[type="text"], input[type="password"] { width:100%; padding:12px 15px; margin-bottom:20px; border:1px solid #d1d5db; border-radius:8px; font-size:16px; transition:0.3s; }
    input[type="text"]:focus, input[type="password"]:focus { border-color:#6366f1; outline:none; }
    button { width:100%; padding:12px; background:#6366f1; border:none; color:#fff; font-size:16px; font-weight:600; border-radius:8px; cursor:pointer; transition:0.3s; }
    button:hover { background:#4f46e5; }
    .error { color:#ef4444; text-align:center; margin-bottom:15px; font-weight:600; }
    .footer { text-align:center; margin-top:20px; color:#9ca3af; font-size:14px; }
</style>
</head>
<body>
<div class="login-container">
    <h2>Mobex ADR Admin Login</h2>
    <?php if($error) echo "<p class='error'>$error</p>"; ?>
    <form method="POST">
        <input type="text" name="username" placeholder="Username" required>
        <input type="password" name="password" placeholder="Password" required>
        <button type="submit" name="login">Login</button>
    </form>
    <div class="footer">© <?= date('Y') ?> Mobex Accra Digital Reset</div>
</div>
</body>
</html>
