<?php
include "includes/db_connect.php";
include "includes/auth.php";
checkAdmin();

// ---------------------------
// Handle AJAX toggle updates
// ---------------------------
if(isset($_POST['action']) && $_POST['action']=='update'){
    $country = $_POST['country_code'];
    $status  = $_POST['status']=='1'?1:0;
    $reason  = $_POST['reason'] ?? '';

    $res = mysqli_query($conn,"SELECT * FROM country_kill_switch WHERE country_code='$country'");
    if(mysqli_num_rows($res)>0){
        mysqli_query($conn,"UPDATE country_kill_switch SET kill_switch=$status, reason='".mysqli_real_escape_string($conn,$reason)."' WHERE country_code='$country'");
    } else {
        mysqli_query($conn,"INSERT INTO country_kill_switch(country_code,kill_switch,reason) VALUES('$country',$status,'".mysqli_real_escape_string($conn,$reason)."')");
    }

    echo json_encode(['success'=>true]);
    exit;
}

// ---------------------------
// Fetch all countries
// ---------------------------
$kill_res = mysqli_query($conn,"SELECT * FROM country_kill_switch ORDER BY country_code");
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Kill Switch - Mobex ADR Admin</title>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
<style>
body { font-family:'Inter', sans-serif; background:#f0f4f8; margin:0; padding:0; }
header { background:#6366f1; color:#fff; padding:15px 20px; display:flex; justify-content:space-between; align-items:center; flex-wrap:wrap; }
header h1 { margin:0; font-size:1.2rem; }
header a { color:#fff; text-decoration:none; font-weight:600; }
.container { max-width:1000px; margin:auto; padding:20px; }
.card { background:#fff; padding:20px; border-radius:12px; box-shadow:0 10px 20px rgba(0,0,0,0.05); }
h2 { margin-bottom:15px; color:#1f2937; font-weight:700; }
.table-responsive { overflow-x:auto; }
table { width:100%; border-collapse:collapse; }
th, td { padding:12px 10px; text-align:left; font-size:0.9rem; }
thead { background:#f3f4f6; }
tr:hover { background:#f9fafb; }
.toggle-switch { position:relative; display:inline-block; width:50px; height:24px; }
.toggle-switch input { opacity:0; width:0; height:0; }
.slider { position:absolute; cursor:pointer; top:0; left:0; right:0; bottom:0; background:#ccc; transition:.4s; border-radius:34px; }
.slider:before { position:absolute; content:""; height:18px; width:18px; left:3px; bottom:3px; background:white; transition:.4s; border-radius:50%; }
input:checked + .slider { background:#6366f1; }
input:checked + .slider:before { transform:translateX(26px); }
.reason-input { width:100%; padding:5px 8px; border-radius:6px; border:1px solid #ccc; font-size:0.9rem; }
@media(max-width:600px){ th,td{font-size:0.8rem; padding:8px 5px;} }
</style>
<script>
function updateKillSwitch(country){
    let checkbox = document.getElementById('chk_'+country);
    let reason = document.getElementById('reason_'+country).value;
    fetch('kill_switch.php',{
        method:'POST',
        headers:{'Content-Type':'application/x-www-form-urlencoded'},
        body:`action=update&country_code=${country}&status=${checkbox.checked?1:0}&reason=${encodeURIComponent(reason)}`
    }).then(r=>r.json()).then(data=>{
        if(data.success){
            let statusLabel = document.getElementById('status_'+country);
            statusLabel.innerText = checkbox.checked?'Blocked':'Active';
        }
    });
}
</script>
</head>
<body>
<?php include "includes/mobex_sidebar.php"; ?>

<div class="container">
<div class="card">
<h2>Country Kill Switch Management</h2>
<div class="table-responsive">
<table>
<thead>
<tr>
<th>Country</th>
<th>Status</th>
<th>Reason</th>
<th>Toggle</th>
</tr>
</thead>
<tbody>
<?php while($row=mysqli_fetch_assoc($kill_res)): ?>
<tr>
<td><?= $row['country_code'] ?></td>
<td id="status_<?= $row['country_code'] ?>"><?= $row['kill_switch']?'Blocked':'Active' ?></td>
<td>
<input type="text" id="reason_<?= $row['country_code'] ?>" class="reason-input" value="<?= htmlspecialchars($row['reason']) ?>" onblur="updateKillSwitch('<?= $row['country_code'] ?>')">
</td>
<td>
<label class="toggle-switch">
<input type="checkbox" id="chk_<?= $row['country_code'] ?>" <?= $row['kill_switch']?'checked':'' ?> onchange="updateKillSwitch('<?= $row['country_code'] ?>')">
<span class="slider"></span>
</label>
</td>
</tr>
<?php endwhile; ?>
</tbody>
</table>
</div>
</div>
</div>
</body>
</html>
