<?php
$currentPage = basename($_SERVER['PHP_SELF']);
$userName = $_SESSION['user_name'] ?? 'User';
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>mobexADR Dashboard</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

<style>
body {
    background-color: #f4f6f9;
    font-family: 'Poppins', sans-serif;
}

/* SIDEBAR */
.sidebar {
    width: 250px;
    height: 100vh;
    background: linear-gradient(180deg, #0b5ed7 0%, #0dcaf0 100%);
    position: fixed;
    top: 0;
    left: 0;
    color: white;
    padding-top: 20px;
    transition: 0.3s ease;
    z-index: 1000;
}

.sidebar.collapsed {
    width: 70px;
}

/* LINKS */
.sidebar a {
    color: white;
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 12px 20px;
    text-decoration: none;
    font-weight: 500;
    white-space: nowrap;
    transition: 0.3s ease;
}

.sidebar a:hover,
.sidebar a.active {
    background: rgba(0,0,0,0.2);
    border-radius: 8px;
}

/* ICONS */
.sidebar a i {
    width: 24px;
    text-align: center;
    font-size: 18px;
}

/* TEXT COLLAPSE */
.sidebar a span {
    transition: 0.2s ease;
}

.sidebar.collapsed a span {
    opacity: 0;
    width: 0;
    overflow: hidden;
}

/* MAIN CONTENT */
.main-content {
    margin-left: 260px;
    padding: 30px;
    transition: 0.3s ease;
}

.main-content.expanded {
    margin-left: 90px;
}

/* TOP BAR */
.topbar {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

/* TOGGLE BTN */
.toggle-btn {
    background: #0b5ed7;
    color: white;
    border: none;
    padding: 8px 12px;
    font-size: 20px;
    border-radius: 6px;
    cursor: pointer;
}

   .mobex-logo {
        text-align: center;
        padding: 10px 15px 25px;
        border-bottom: 1px solid rgba(255,255,255,0.1);
    }

    .mobex-logo img {
        max-width: 180px;
        height: auto;
    }

    .mobex-logo .tagline {
        font-size: 11px;
        color: #9fb3c8;
        margin-top: 6px;
        letter-spacing: 0.5px;
    }

</style>
</head>

<body>

<!-- ===== SIDEBAR ===== -->
<div id="sidebarMenu" class="sidebar">

   <!-- LOGO -->
    <div class="mobex-logo">
        <img src="assets/img/madr_logo.png" alt="MobEx MADR Logo">
        <div class="tagline">
            Cross-Border Mobile Money Platform
        </div>
    </div>

    <a href="dashboard.php" class="<?= $currentPage=='dashboard.php'?'active':'' ?>">
        <i class="fa fa-chart-line"></i>
        <span>Dashboard</span>
    </a>

    <!--<a href="wallets.php" class="<?= $currentPage=='wallets.php'?'active':'' ?>">-->
    <!--    <i class="fa fa-wallet"></i>-->
    <!--    <span>Wallets</span>-->
    <!--</a>-->

    <a href="fx_rates.php" class="<?= $currentPage=='fx_rates.php'?'active':'' ?>">
        <i class="fa fa-coins"></i>
        <span>FX Rates</span>
    </a>

    <a href="transactions.php" class="<?= $currentPage=='transactions.php'?'active':'' ?>">
        <i class="fa fa-right-left"></i>
        <span>Transactions</span>
    </a>
    
        <a href="country_transaction_amount_summary.php" class="<?= $currentPage=='country_transaction_amount_summary.php'?'active':'' ?>">
        <i class="fa fa-right-left"></i>
        <span>Country Transactions</span>
    </a>
    
    <a class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'flagged_recipients.php' ? 'active' : '' ?>" 
   href="flagged_recipients.php">
    <i class="fa fa-shield-alt"></i> Flagged Recipients
</a>

    <a href="limit_violations.php" class="<?= $currentPage=='limit_violations.php'?'active':'' ?>">
        <i class="fa fa-id-card"></i>
        <span>Compliance</span>
    </a>
    
    <a href="fraud_dashboard.php" class="<?= $currentPage=='fraud_dashboard.php'?'active':'' ?>"><i class="fa fa-chart-line"></i> Fraud Dashboard</a>

    <!--<a href="settings.php" class="<?= $currentPage=='settings.php'?'active':'' ?>">-->
    <!--    <i class="fa fa-gear"></i>-->
    <!--    <span>Settings</span>-->
    <!--</a>-->
<a href="kill_switch.php"><i class="fa fa-power-off"></i> Kill Switch</a>
    <a href="countries.php"><i class="fa fa-globe"></i> Countries</a>
    <a href="../logout.php">
        <i class="fa fa-right-from-bracket"></i>
        <span>Logout</span>
    </a>
</div>

<!-- ===== MAIN CONTENT ===== -->
<div id="mainContent" class="main-content">

    <div class="topbar">
        <div class="d-flex align-items-center gap-3">
            <button id="toggleSidebar" class="toggle-btn">
                <i class="fa fa-bars"></i>
            </button>
            <h4 class="m-0">Welcome, <?= htmlspecialchars($userName); ?></h4>
        </div>

        <a href="../logout.php" class="btn btn-danger btn-sm">Logout</a>
    </div>
