<?php
session_start();
include('includes/db_connect.php');
if(!isset($_SESSION['admin'])) header("Location: index.php");

// -----------------------------
// Handle Save / Update
// -----------------------------
if(isset($_POST['save'])){
    $id = intval($_POST['id'] ?? 0);
    $from = strtoupper(trim($_POST['from_currency'] ?? ''));
    $to   = strtoupper(trim($_POST['to_currency'] ?? ''));
    $rate = floatval($_POST['rate'] ?? 0);
    $source = in_array($_POST['source'], ['SANDBOX','LIVE']) ? $_POST['source'] : 'SANDBOX';

    if($id > 0){
        // Update existing
        $conn->query("
            UPDATE fx_rates 
            SET from_currency='$from', to_currency='$to', rate=$rate, source='$source' 
            WHERE id=$id
        ");
    } else {
        // Insert new
        $conn->query("
            INSERT INTO fx_rates (from_currency, to_currency, rate, source) 
            VALUES ('$from','$to',$rate,'$source')
        ");
    }
}

// -----------------------------
// Fetch FX Rates
// -----------------------------
$fx_res = $conn->query("SELECT * FROM fx_rates ORDER BY from_currency, to_currency");
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>FX Rates - MADR</title>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
<link rel="stylesheet" href="assets/css/styles.css">
<style>
body { font-family:'Inter',sans-serif; background:#f0f4f8; margin:0; }
.main-content { margin-left:260px; padding:30px; transition:0.3s; min-height:100vh; }
.card { background:#fff; border-radius:12px; padding:20px; margin-bottom:20px; box-shadow:0 5px 15px rgba(0,0,0,0.05); }
table { width:100%; border-collapse:collapse; }
th, td { padding:10px 12px; text-align:left; }
th { background:#f3f4f6; }
input[type="number"], input[type="text"], select { width:100%; padding:6px 8px; border-radius:6px; border:1px solid #ccc; }
button { padding:6px 12px; background:#0b1c2d; color:#fff; border:none; border-radius:6px; cursor:pointer; }
button:hover { background:#142f4a; }

/* Responsive fix */
@media(max-width:768px){
    .main-content { margin-left:70px; padding:20px; }
    table, thead, tbody, th, td, tr { display:block; width:100%; }
    tr { margin-bottom:15px; border-bottom:1px solid #eee; }
    th { background:#0b1c2d; color:#fff; padding:8px; border-radius:6px 6px 0 0; }
    td { padding:8px; position:relative; padding-left:50%; }
    td::before { 
        content: attr(data-label);
        position:absolute; left:12px; font-weight:bold; color:#333;
    }
}
</style>
</head>
<body>

<?php include('includes/mobex_sidebar.php'); ?>

<div class="container">
    <h2>Manage FX Rates</h2>

    <!-- Add / Update FX Rate -->
    <div class="card" style="margin-bottom:25px;">
        <form method="POST" style="display:flex;gap:10px;flex-wrap:wrap;">
            <input type="hidden" name="id" value="">
            <input type="text" name="from_currency" placeholder="From Currency (e.g., USD)" required>
            <input type="text" name="to_currency" placeholder="To Currency (e.g., GH₵)" required>
            <input type="number" step="0.000001" name="rate" placeholder="Rate" required>
            <select name="source" required>
                <option value="SANDBOX">SANDBOX</option>
                <option value="LIVE">LIVE</option>
            </select>
            <button type="submit" name="save"><i class="fa fa-plus"></i> Add / Update</button>
        </form>
    </div>

    <!-- FX Rates Table -->
    <div class="card">
        <table>
            <thead>
                <tr>
                    <th>From</th>
                    <th>To</th>
                    <th>Rate</th>
                    <th>Source</th>
                    <th>Updated At</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php while($fx = $fx_res->fetch_assoc()): ?>
                <tr>
                    <form method="POST">
                        <input type="hidden" name="id" value="<?= $fx['id'] ?>">
                        <td data-label="From"><input type="text" name="from_currency" value="<?= $fx['from_currency'] ?>" required></td>
                        <td data-label="To"><input type="text" name="to_currency" value="<?= $fx['to_currency'] ?>" required></td>
                        <td data-label="Rate"><input type="number" step="0.000001" name="rate" value="<?= $fx['rate'] ?>" required></td>
                        <td data-label="Source">
                            <select name="source" required>
                                <option value="SANDBOX" <?= $fx['source']=='SANDBOX'?'selected':'' ?>>SANDBOX</option>
                                <option value="LIVE" <?= $fx['source']=='LIVE'?'selected':'' ?>>LIVE</option>
                            </select>
                        </td>
                        <td data-label="Updated At"><?= $fx['updated_at'] ?></td>
                        <td data-label="Actions"><button type="submit" name="save"><i class="fa fa-edit"></i> Update</button></td>
                    </form>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>

</div>

<script>
    // Sidebar toggle
    document.getElementById('toggleSidebar')?.addEventListener('click', function () {
        document.getElementById('sidebarMenu').classList.toggle('collapsed');
        document.querySelector('.main-content').classList.toggle('expanded');
    });
</script>

</body>
</html>
