<?php
// country_transaction_list.php

error_reporting(E_ALL);
ini_set('display_errors', 1);

include "includes/db_connect.php";
include "includes/auth.php";
checkAdmin();

// Fetch flagged transactions summary
$riskSummary = [];
$dailyTrend = [];

// ---------------------------
// 1. Risk Level Summary
// ---------------------------
$sqlRisk = "SELECT risk_level, COUNT(*) as total 
            FROM transactions 
            WHERE is_flagged = 1 
            GROUP BY risk_level";
$resRisk = $conn->query($sqlRisk);

while ($row = $resRisk->fetch_assoc()) {
    $riskSummary[$row['risk_level']] = (int)$row['total'];
}

// ---------------------------
// 2. Daily Fraud Trend (Last 7 Days)
// ---------------------------
$sqlTrend = "SELECT DATE(created_at) as day, COUNT(*) as total
             FROM transactions
             WHERE is_flagged = 1
             AND created_at >= DATE_SUB(CURDATE(), INTERVAL 6 DAY)
             GROUP BY day
             ORDER BY day ASC";
$resTrend = $conn->query($sqlTrend);

$trendLabels = [];
$trendData = [];

while ($row = $resTrend->fetch_assoc()) {
    $trendLabels[] = $row['day'];
    $trendData[] = (int)$row['total'];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Fraud Analytics Dashboard</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<style>
.card { margin-bottom: 20px; }
</style>
</head>
<body>
    <?php include "includes/mobex_sidebar.php"; ?>
<div class="container mt-4">

    <h2>Fraud Analytics Dashboard</h2>
    <p>Summary of flagged transactions and risk trends</p>

    <div class="row">

        <!-- Risk Level Summary -->
        <div class="col-md-6">
            <div class="card p-3">
                <h4><i class="fa fa-shield-alt"></i> Risk Level Distribution</h4>
                <canvas id="riskChart"></canvas>
            </div>
        </div>

        <!-- Daily Trend Chart -->
        <div class="col-md-6">
            <div class="card p-3">
                <h4><i class="fa fa-chart-line"></i> Daily Fraud Trend (Last 7 Days)</h4>
                <canvas id="dailyTrendChart"></canvas>
            </div>
        </div>
    </div>

    <div class="row mt-3">
        <!-- Export CSV -->
        <div class="col-md-12">
            <a href="fraud_export.php" class="btn btn-danger"><i class="fa fa-file-csv"></i> Export Fraud Report CSV</a>
        </div>
    </div>

</div>

<script>
// ---------------------------
// Risk Level Chart
// ---------------------------
const riskCtx = document.getElementById('riskChart').getContext('2d');
new Chart(riskCtx, {
    type: 'bar',
    data: {
        labels: ['LOW', 'MEDIUM', 'HIGH'],
        datasets: [{
            label: 'Flagged Transactions',
            data: [
                <?= $riskSummary['LOW'] ?? 0 ?>,
                <?= $riskSummary['MEDIUM'] ?? 0 ?>,
                <?= $riskSummary['HIGH'] ?? 0 ?>
            ],
            backgroundColor: ['#28a745','#ffc107','#dc3545']
        }]
    },
    options: {
        responsive: true,
        plugins: { legend: { display: false } },
        scales: { y: { beginAtZero: true } }
    }
});

// ---------------------------
// Daily Fraud Trend Chart
// ---------------------------
const trendCtx = document.getElementById('dailyTrendChart').getContext('2d');
new Chart(trendCtx, {
    type: 'line',
    data: {
        labels: <?= json_encode($trendLabels) ?>,
        datasets: [{
            label: 'Flagged Transactions',
            data: <?= json_encode($trendData) ?>,
            borderColor: '#dc3545',
            backgroundColor: 'rgba(220,53,69,0.2)',
            fill: true,
            tension: 0.3
        }]
    },
    options: {
        responsive: true,
        plugins: { legend: { display: false } },
        scales: { y: { beginAtZero: true, stepSize: 1 } }
    }
});
</script>

</body>

</html>