<?php
// country_transaction_list.php

error_reporting(E_ALL);
ini_set('display_errors', 1);

include "includes/db_connect.php";
include "includes/auth.php";
checkAdmin();

$result = $conn->query("
    SELECT *
    FROM high_risk_recipients
    ORDER BY flagged_at DESC
");
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Regulatory Dashboard - Mobex ADR Admin</title>

<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">

<style>
body { font-family:'Inter',sans-serif; background:#f0f4f8; margin:0; }
.container { max-width:1000px; margin:auto; padding:20px; }
.card { background:#fff; padding:20px; border-radius:12px;
        box-shadow:0 10px 20px rgba(0,0,0,0.05); margin-bottom:20px; }
h2 { margin-bottom:15px; color:#1f2937; }
.table-responsive { overflow-x:auto; }
table { width:100%; border-collapse:collapse; }
th, td { padding:10px 8px; font-size:0.85rem; }
thead { background:#f3f4f6; }
tr:hover { background:#f9fafb; }
.status-label { font-weight:600; padding:3px 6px; border-radius:6px; color:#fff; font-size:0.75rem; }
.status-INITIATED { background:#f59e0b; }
.status-QUEUED { background:#3b82f6; }
.status-SETTLED { background:#10b981; }
.status-FAILED { background:#ef4444; }
.pagination { display:flex; justify-content:center; gap:5px; margin-top:10px; flex-wrap:wrap; }
.pagination a { padding:5px 10px; background:#6366f1; color:#fff;
                border-radius:6px; text-decoration:none; }
.pagination a.active { background:#4f46e5; font-weight:600; }
input, select { padding:6px 8px; border-radius:6px; border:1px solid #d1d5db; }
button { background:#6366f1; color:#fff; border:none;
         padding:6px 12px; border-radius:6px; cursor:pointer; }
</style>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
let chartData = {}, labels = [], chart;

function fetchChart(){
    fetch('transactions.php?ajax=chart')
    .then(r=>r.json())
    .then(data=>{
        chartData = data;
        labels = [...new Set([].concat(...Object.values(chartData).map(a=>a.map(d=>d.date))))];
        renderChart();
    });
}

function renderChart(){
    let ctx = document.getElementById('countryChart');
    if(chart) chart.destroy();

    chart = new Chart(ctx,{
        type:'bar',
        data:{
            labels:labels,
            datasets:Object.keys(chartData).map(c=>{
                let totals = labels.map(d=>{
                    let f = chartData[c].find(e=>e.date===d);
                    return f ? f.total : 0;
                });
                let col = '#'+Math.floor(Math.random()*16777215).toString(16);
                return {label:c,data:totals,backgroundColor:col};
            })
        },
        options:{responsive:true, scales:{y:{beginAtZero:true}}}
    });
}

window.onload = ()=>{ fetchChart(); setInterval(fetchChart,10000); };
</script>
</head>

<body>
<?php include "includes/mobex_sidebar.php"; ?>

<div class="card" style="margin-bottom:15px;">


<h2>High Risk Recipients</h2>

<div class="card table-responsive">
    
    <table>
    <thead>
    <tr>
        <th>MSISDN</th>
        <th>Reason</th>
        <th>Risk Score</th>
        <th>Blocked Until</th>
        <th>Status</th>
        <th>Action</th>
    </tr>
    </thead>
    <tbody>

<?php while($row = $result->fetch_assoc()): ?>
<tr>
    <td><?= $row['msisdn'] ?></td>
    <td><?= $row['risk_reason'] ?></td>
    <td><?= $row['risk_score'] ?></td>
    <td><?= $row['blocked_until'] ?></td>
    <td><?= $row['active'] ? 'BLOCKED' : 'CLEARED' ?></td>
    <td>
        <?php if($row['active']): ?>
            <a href="unblock.php?id=<?= $row['id'] ?>">Unblock</a>
        <?php endif; ?>
    </td>
</tr>
</tbody>
<?php endwhile; ?>
</table>
</div>