<?php
include "includes/db_connect.php";
include "includes/auth.php";
checkAdmin();

// ----------------------
// Filters
// ----------------------
$fromDate  = $_GET['from_date'] ?? '';
$toDate    = $_GET['to_date'] ?? '';
$toCountry = $_GET['to_country'] ?? '';

$where = [];

if ($toCountry !== '') {
    $safe = mysqli_real_escape_string($conn, $toCountry);
    $where[] = "to_country = '$safe'";
}

if ($fromDate !== '' && $toDate !== '') {
    $safeFrom = mysqli_real_escape_string($conn, $fromDate);
    $safeTo   = mysqli_real_escape_string($conn, $toDate);
    $where[]  = "DATE(created_at) BETWEEN '$safeFrom' AND '$safeTo'";
}

$whereSQL = count($where) ? "WHERE " . implode(" AND ", $where) : "";

// ----------------------
// Fetch country list
// ----------------------
$country_res = mysqli_query($conn, "
    SELECT DISTINCT to_country
    FROM transactions
    ORDER BY to_country ASC
");

// ----------------------
// Summary Query
// ----------------------
$summary_res = mysqli_query($conn, "
    SELECT
        to_country,

        SUM(send_amount) AS total_amount,

        SUM(CASE WHEN status = 'SETTLED'
            THEN send_amount ELSE 0 END) AS settled_amount,

        SUM(CASE WHEN status = 'FAILED'
            THEN send_amount ELSE 0 END) AS failed_amount,

        SUM(CASE WHEN status = 'QUEUED'
            THEN send_amount ELSE 0 END) AS queued_amount

    FROM transactions
    $whereSQL
    GROUP BY to_country
    ORDER BY total_amount DESC
");

// Helper to preserve filters in links
function buildLink($country, $status = '') {
    $params = [
        'to_country' => $country
    ];

    if (!empty($_GET['from_date'])) {
        $params['from_date'] = $_GET['from_date'];
    }
    if (!empty($_GET['to_date'])) {
        $params['to_date'] = $_GET['to_date'];
    }
    if ($status !== '') {
        $params['status'] = $status;
    }

    return 'country_transaction_list.php?' . http_build_query($params);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Country Transaction Amount Performance Summary</title>

<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">

<style>
body { font-family:'Inter',sans-serif; background:#f0f4f8; margin:0; }
.container { max-width:1000px; margin:auto; padding:20px; }
.card {
    background:#fff;
    padding:20px;
    border-radius:12px;
    box-shadow:0 10px 20px rgba(0,0,0,0.05);
}
h2 { margin-bottom:5px; color:#1f2937; }
small { color:#6b7280; }
.table-responsive { overflow-x:auto; margin-top:15px; }
table { width:100%; border-collapse:collapse; }
th, td { padding:10px 8px; font-size:0.85rem; }
thead { background:#f3f4f6; }
tr:hover { background:#f9fafb; }
input, select {
    padding:6px 8px;
    border-radius:6px;
    border:1px solid #d1d5db;
}
button {
    background:#6366f1;
    color:#fff;
    border:none;
    padding:6px 12px;
    border-radius:6px;
    cursor:pointer;
}
.metric-ok { color:#10b981; font-weight:600; }
.metric-bad { color:#ef4444; font-weight:600; }
.metric-warn { color:#3b82f6; font-weight:600; }
.metric-total { font-weight:700; }
a { text-decoration:none; }
a:hover { text-decoration:underline; }
</style>
</head>

<body>
<?php include "includes/mobex_sidebar.php"; ?>

<div class="container">

<div class="card">
<h2>Country Transaction Amount Performance Summary</h2>
<small>Total value of Settled, Failed, and Queued transactions by destination country</small>

<!-- FILTERS -->
<form method="GET" style="margin-top:15px;display:flex;gap:10px;flex-wrap:wrap;">
    <select name="to_country">
        <option value="">All To Countries</option>
        <?php while($c = mysqli_fetch_assoc($country_res)): ?>
            <option value="<?= $c['to_country'] ?>"
                <?= $toCountry == $c['to_country'] ? 'selected' : '' ?>>
                <?= $c['to_country'] ?>
            </option>
        <?php endwhile; ?>
    </select>

    <input type="date" name="from_date" value="<?= $fromDate ?>">
    <input type="date" name="to_date" value="<?= $toDate ?>">

    <button type="submit">Apply Filters</button>
</form>

<!-- SUMMARY TABLE -->
<div class="table-responsive">
<table>
<thead>
<tr>
    <th>To Country</th>
    <th>Total Amount</th>
    <th>Settled Amount</th>
    <th>Failed Amount</th>
    <th>Queued Amount</th>
</tr>
</thead>
<tbody>
<?php while($row = mysqli_fetch_assoc($summary_res)): ?>
<tr>
    <td><strong><?= $row['to_country'] ?></strong></td>

    <td class="metric-total">
        <a href="<?= buildLink($row['to_country']) ?>">
            <?= number_format($row['total_amount'], 2) ?>
        </a>
    </td>

    <td class="metric-ok">
        <a href="<?= buildLink($row['to_country'], 'SETTLED') ?>">
            <?= number_format($row['settled_amount'], 2) ?>
        </a>
    </td>

    <td class="metric-bad">
        <a href="<?= buildLink($row['to_country'], 'FAILED') ?>">
            <?= number_format($row['failed_amount'], 2) ?>
        </a>
    </td>

    <td class="metric-warn">
        <a href="<?= buildLink($row['to_country'], 'QUEUED') ?>">
            <?= number_format($row['queued_amount'], 2) ?>
        </a>
    </td>
</tr>
<?php endwhile; ?>
</tbody>
</table>
</div>

</div>
</div>
</body>
</html>
