<?php

function check_route_enabled($conn, $fromCountry, $toCountry)
{
    $stmt = $conn->prepare("
        SELECT enabled, preferred_provider
        FROM routing_matrix
        WHERE from_country = ?
        AND to_country = ?
        LIMIT 1
    ");

    $stmt->bind_param("ss", $fromCountry, $toCountry);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();

    if (!$result) {
        return [
            'allowed' => false,
            'reason' => 'Route not configured'
        ];
    }

    if ($result['enabled'] != 1) {
        return [
            'allowed' => false,
            'reason' => 'Route disabled'
        ];
    }

    return [
        'allowed' => true,
        'preferred_provider' => $result['preferred_provider']
    ];
}
