<?php
include('../config.php');
session_start();
$user_id = $_SESSION['user_id'] ?? null;
if (!$user_id) { 
    header("Location: login.php"); 
    exit; 
}

// Fetch user phone
$stmt = $conn->prepare("SELECT * FROM users WHERE id=? LIMIT 1");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
$stmt->close();
$phone = $user['phone'] ?? '';

if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $message = $_POST['message'] ?? '';
    if($message){
        $stmt = $conn->prepare("INSERT INTO support_messages (user_id, phone, message, date_sent) VALUES (?, ?, ?, NOW())");
        $stmt->bind_param("iss", $user_id, $phone, $message);
        $stmt->execute();
        $stmt->close();
        $success = "Message sent successfully!";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>3y3 SUPA History</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>


<style>

/* ===== GLOBAL ===== */
body {
    margin: 0;
    font-family: 'Poppins', sans-serif;
    background: #F4F6F9;
    display: flex;
}

/* ===== SIDEBAR ===== */
.sidebar {
    width: 240px;
    background: #002147;
    color: #fff;
    position: fixed;
    left: 0;
    top: 0;
    bottom: 0;
    display: flex;
    flex-direction: column;
    padding: 20px 0;
}

.sidebar .logo {
    text-align: center;
    margin-bottom: 25px;
}

.sidebar a {
    padding: 14px 25px;
    text-decoration: none;
    color: #fff;
    display: flex;
    align-items: center;
    gap: 12px;
    font-size: 14px;
    transition: 0.3s;
}

.sidebar a:hover,
.sidebar a.active {
    background: #C9A227;
    color: #002147;
    font-weight: 600;
}

/* Push logout to bottom */
.sidebar a.logout {
    margin-top: auto;
}

/* ===== MAIN ===== */
.main {
    margin-left: 240px;
    width: 100%;
    min-height: 100vh;
    display: flex;
    flex-direction: column;
}

/* HEADER */
header {
    background: linear-gradient(135deg, #002147 0%, #001530 100%);
    border-bottom: 4px solid #C9A227;
    padding: 15px 20px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    color: #fff;
}


.logo-area {
    display: flex;
    align-items: center;
    gap: 12px;
}

.logo-area img {
    height: 45px;
}

.header-right {
    display: flex;
    align-items: center;
    gap: 15px;
}

.logout-link {
    color: #fff;
    font-size: 18px;
}

/* National Bar */
.national-bar {
    background: #C9A227;
    color: #002147;
    padding: 8px 20px;
    font-size: 13px;
    font-weight: 600;
    display: flex;
    justify-content: space-between;
}

/* Container */
.container {
    padding: 25px;
}

/* Executive Panel */
.executive-panel {
    background: #fff;
    border-radius: 16px;
    padding: 20px;
    margin-bottom: 25px;
    display: flex;
    justify-content: space-between;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
}

.exec-item small {
    color: #5A5A5A;
}

.exec-item h3 {
    margin-top: 5px;
    color: #002147;
}

.active-status {
    color: #1E7E34;
}

/* Cards */
.cards {
    display: grid;
    grid-template-columns: repeat(2, 1fr); /* ALWAYS 2 per row */
    gap: 15px;
    margin-bottom: 25px;
}

.card {
    background: #fff;
    border-radius: 18px;
    padding: 16px; /* reduced padding */
    text-align: center;
    border: 1px solid #E5E5E5;
    box-shadow: 0 6px 18px rgba(0,0,0,0.05);
    transition: 0.25s ease;
    cursor: pointer;
    min-height: 120px; /* keeps them compact */
    display: flex;
    flex-direction: column;
    justify-content: center;
}

.card:hover {
    transform: translateY(-4px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
}

.card i {
    font-size: 24px; /* slightly smaller icon */
    color: #C9A227;
    margin-bottom: 8px;
}

.card div {
    font-weight: 600;
    color: #002147;
    font-size: 15px;
}


/* Chart */
.chart-card {
    background: #fff;
    padding: 20px;
    border-radius: 16px;
    margin-bottom: 25px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.08);
}

/* Contributions */
.section h2 {
    color: #002147;
}

.contribution-list {
    list-style: none;
    padding: 0;
}

.contribution-list li {
    background: #fff;
    margin-bottom: 10px;
    padding: 15px;
    border-radius: 12px;
    display: flex;
    justify-content: space-between;
    box-shadow: 0 4px 15px rgba(0,0,0,0.05);
}

.status {
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
}

.status.success { background: #E6F4EA; color: #1E7E34; }
.status.pending { background: #FFF8E1; color: #856404; }
.status.failed { background: #FDECEA; color: #721C24; }


footer {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background: #f5f5f5; /* light grey / whitish */
    color: #333; /* dark text for contrast */
    text-align: center;
    padding: 12px 0;
    font-size: 14px;
    box-shadow: 0 -3px 10px rgba(0,0,0,0.1);
}

footer a {
    color: #002147; /* optional: make any links dark blue */
    text-decoration: none;
}

@media (max-width: 400px) {
    footer {
        font-size: 12px;
        padding: 10px 0;
    }
}


/* Freeze Top Section */
.top-fixed {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    background: #F4F6F9;
    z-index: 1000;
}

/* Give space so content doesn't hide behind fixed header */
.scroll-area {
    margin-top: 2px; /* Adjust if needed */
    padding: 20px;
}

/* Optional: subtle shadow for premium look */
/*.top-fixed {*/
/*    box-shadow: 0 5px 20px rgba(0,0,0,0.08);*/
/*}*/


.header-right { display:flex; align-items:center; gap:15px; }
.header-right .logout-link { color:#fff; font-size:18px; margin-left:5px; }
.container { padding: 30px 20px 50px 20px; max-width:400px; margin:auto; }
.contribution-list { list-style:none; padding:0; margin:0; }
.contribution-list li { background:#fff; margin-bottom:10px; padding:15px; border-radius:12px; box-shadow:0 4px 15px rgba(0,0,0,0.05); display:flex; justify-content:space-between; font-size:14px; }
.pagination { display:flex; justify-content:center; margin-top:20px; gap:5px; flex-wrap:wrap; }
.pagination a, .pagination span { padding:8px 12px; background:#fff; border-radius:8px; border:1px solid #ddd; color:#333; text-decoration:none; transition:0.3s; }
.pagination a:hover { background:#F58220; color:#fff; }
.pagination .current { background:#C9A227; color:#fff; border-color:#D85C00; }

/* Responsive */
@media(max-width: 768px){
    .container.shift { margin-left: 0; }
    .card i { font-size: 24px; }
    .card span { font-size: 14px; }
}

/* Support form container */
.support-form {
    max-width: 400px;
    margin: 20px auto;
    padding: 15px;
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 6px 20px rgba(0,0,0,0.08);
}

/* Textarea styling */
.support-form textarea {
    width: 90%;
    min-height: 220px;
    padding: 20px;
    border: 1px solid #ccc;
    border-radius: 10px;
    font-size: 16px;
    resize: vertical;
    outline: none;
    transition: border-color 0.2s, box-shadow 0.2s;
}

.support-form textarea:focus {
    border-color: #F58220;
    box-shadow: 0 0 6px rgba(245,130,32,0.3);
}

/* Submit button */
.support-form button {
    width: 100%;
    background: linear-gradient(135deg, #F58220, #C9A227);
    border: none;
    color: #fff;
    font-size: 16px;
    font-weight: 600;
    padding: 12px;
    border-radius: 10px;
    cursor: pointer;
    margin-top: 12px;
    transition: background 0.3s;
}

.support-form button:hover {
    background: linear-gradient(135deg, #D85C00, #F58220);
}

/* Success message */
.support-form .success-msg {
    text-align: center;
    color: #28a745;
    margin-top: 10px;
    font-weight: 500;
}

</style>
<body>

<div class="sidebar">
    <div class="logo">
        <div style="font-weight:600;">3y3 SUPA</div>
    </div>

    <a href="dashboard.php"><i class="fa-solid fa-gauge"></i><span>Dashboard</span></a>
    <a href="contribute.php"><i class="fa-solid fa-money-bill-wave"></i><span>Contribute</span></a>
    <a href="history.php"><i class="fa-solid fa-clock-rotate-left"></i><span>History</span></a>
    <a href="projection.php"><i class="fa-solid fa-chart-line"></i><span>Projection</span></a>
    <a href="support.php" class="active"><i class="fa-solid fa-headset"></i><span>Support</span></a>
    <a href="beneficiaries.php"><i class="fa-solid fa-users"></i><span>Beneficiaries</span></a>
    <a href="balance.php"><i class="fa-solid fa-wallet"></i><span>Balance</span></a>

    <a href="logout.php" class="">
        <i class="fa-solid fa-right-from-bracket"></i><span>Logout</span>
    </a>
</div>

<div class="main">

<header>
    <div><i class="fa-solid fa-user"></i> <?=htmlspecialchars($user['full_name'])?></div>
</header>

<div class="national-bar">
    <div>3y3 Supa</div>
    <div>Secure Today. Enjoy Tomorrow.</div>
</div>
<p>
<div class="support-form">
    <form method="POST" action="">
        <textarea name="message" placeholder="Write your question or suggestion here ..." required></textarea>
        <button type="submit">Send Message</button>
        <?php if(isset($success)): ?>
            <div class="success-msg"><?=htmlspecialchars($success)?></div>
        <?php endif; ?>
    </form>
</div>
</p>
</div>
<footer>
    &copy; <?=date('Y')?> 3y3 Supa. Powered by Tekpulse Consult Ltd.
</footer>

<style>
footer {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background: #f5f5f5; /* light grey / whitish */
    color: #333; /* dark text for contrast */
    text-align: center;
    padding: 12px 0;
    font-size: 14px;
    box-shadow: 0 -3px 10px rgba(0,0,0,0.1);
}

footer a {
    color: #002147; /* optional: make any links dark blue */
    text-decoration: none;
}

@media (max-width: 400px) {
    footer {
        font-size: 12px;
        padding: 10px 0;
    }
}
</style>

</body>
</html>
