<?php
include('../config.php');
include('includes/header.php');

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = trim($_POST['full_name'] ?? '');
    $phone = preg_replace('/\D/', '', $_POST['phone'] ?? '');
    $pin = $_POST['pin'] ?? '';
    $network = trim($_POST['network'] ?? '');

    if (!$full_name || !$phone || !$pin || !$network) {
        $error = "All fields are required";
    } elseif (!preg_match('/^\d{4,6}$/', $pin)) {
        $error = "PIN must be 4-6 digits";
    } else {

        if (strlen($phone) == 10 && substr($phone, 0, 1) == '0') {
            $phone = '233' . substr($phone, 1);
        }

        $stmt = $conn->prepare("SELECT id FROM users WHERE phone=? LIMIT 1");
        $stmt->bind_param("s", $phone);
        $stmt->execute();
        $existing = $stmt->get_result()->fetch_assoc();
        $stmt->close();

        if ($existing) {
            $error = "Phone number already registered";
        } else {
            $hashed_pin = password_hash($pin, PASSWORD_DEFAULT);
            $registration_channel = 'WEB';

            $stmt = $conn->prepare("INSERT INTO users (full_name, phone, pin, network, balance, registration_channel) VALUES (?, ?, ?, ?, 0, ?)");
            $stmt->bind_param("sssss", $full_name, $phone, $hashed_pin, $network, $registration_channel);

            if ($stmt->execute()) {
                $success = "Registration successful! You can now login.";
            } else {
                $error = "Registration failed. Please try again.";
            }

            $stmt->close();
        }
    }
}
?>

<div class="card">
    <h2 style="color:#F58220;">Join 3y3 Supa Today</h2>

    <?php if($success): ?>
        <div class="success"><?=htmlspecialchars($success)?></div>
    <?php endif; ?>

    <?php if($error): ?>
        <div class="error"><?=htmlspecialchars($error)?></div>
    <?php endif; ?>

    <form method="POST">
        <input type="text" name="full_name" placeholder="Full Name" required>
        <input type="tel" name="phone" placeholder="Phone Number" required>
        <input type="password" name="pin" placeholder="PIN (4-6 digits)" required>

        <select name="network" required>
            <option value="">Select Network</option>
            <option value="MTN">MTN</option>
            <option value="Vodafone">Vodafone</option>
            <option value="AirtelTigo">AirtelTigo</option>
        </select>

        <button type="submit">Register</button>
    </form>

    <p>
        Already registered? <a href="login.php">Login here</a>
    </p>
</div>

<?php include('includes/footer.php'); ?>