<?php
// projection.php
include('../config.php');
session_start();

$user_id = $_SESSION['user_id'] ?? null;
if (!$user_id) { 
    header("Location: login.php"); 
    exit; 
}

// Fetch user info
$stmt = $conn->prepare("SELECT full_name, balance FROM users WHERE id=? LIMIT 1");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
$stmt->close();

// Fetch total contributions
$stmt = $conn->prepare("SELECT SUM(amount) as total_contrib FROM payments WHERE user_id=? AND status='success'");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$totalRow = $stmt->get_result()->fetch_assoc();
$total_contrib = floatval($totalRow['total_contrib'] ?? 0);
$stmt->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>3y3 SUPA History</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>


<style>

/* ===== GLOBAL ===== */
body {
    margin: 0;
    font-family: 'Poppins', sans-serif;
    background: #F4F6F9;
    display: flex;
}

/* ===== SIDEBAR ===== */
.sidebar {
    width: 240px;
    background: #002147;
    color: #fff;
    position: fixed;
    left: 0;
    top: 0;
    bottom: 0;
    display: flex;
    flex-direction: column;
    padding: 20px 0;
}

.sidebar .logo {
    text-align: center;
    margin-bottom: 25px;
}

.sidebar a {
    padding: 14px 25px;
    text-decoration: none;
    color: #fff;
    display: flex;
    align-items: center;
    gap: 12px;
    font-size: 14px;
    transition: 0.3s;
}

.sidebar a:hover,
.sidebar a.active {
    background: #C9A227;
    color: #002147;
    font-weight: 600;
}

/* Push logout to bottom */
.sidebar a.logout {
    margin-top: auto;
}

/* ===== MAIN ===== */
.main {
    margin-left: 240px;
    width: 100%;
    min-height: 100vh;
    display: flex;
    flex-direction: column;
}

/* HEADER */
header {
    background: linear-gradient(135deg, #002147 0%, #001530 100%);
    border-bottom: 4px solid #C9A227;
    padding: 15px 20px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    color: #fff;
}


.logo-area {
    display: flex;
    align-items: center;
    gap: 12px;
}

.logo-area img {
    height: 45px;
}

.header-right {
    display: flex;
    align-items: center;
    gap: 15px;
}

.logout-link {
    color: #fff;
    font-size: 18px;
}

/* National Bar */
.national-bar {
    background: #C9A227;
    color: #002147;
    padding: 8px 20px;
    font-size: 13px;
    font-weight: 600;
    display: flex;
    justify-content: space-between;
}

/* Container */
.container {
    padding: 25px;
}

/* Executive Panel */
.executive-panel {
    background: #fff;
    border-radius: 16px;
    padding: 20px;
    margin-bottom: 25px;
    display: flex;
    justify-content: space-between;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
}

.exec-item small {
    color: #5A5A5A;
}

.exec-item h3 {
    margin-top: 5px;
    color: #002147;
}

.active-status {
    color: #1E7E34;
}

/* Cards */
.cards {
    display: grid;
    grid-template-columns: repeat(2, 1fr); /* ALWAYS 2 per row */
    gap: 15px;
    margin-bottom: 25px;
}


.card:hover {
    transform: translateY(-4px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
}

.card i {
    font-size: 24px; /* slightly smaller icon */
    color: #C9A227;
    margin-bottom: 8px;
}

.card div {
    font-weight: 600;
    color: #002147;
    font-size: 15px;
}


/* Chart */
.chart-card {
    background: #fff;
    padding: 20px;
    border-radius: 16px;
    margin-bottom: 25px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.08);
}

/* Contributions */
.section h2 {
    color: #002147;
}

.contribution-list {
    list-style: none;
    padding: 0;
}

.contribution-list li {
    background: #fff;
    margin-bottom: 10px;
    padding: 15px;
    border-radius: 12px;
    display: flex;
    justify-content: space-between;
    box-shadow: 0 4px 15px rgba(0,0,0,0.05);
}

.status {
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
}

.status.success { background: #E6F4EA; color: #1E7E34; }
.status.pending { background: #FFF8E1; color: #856404; }
.status.failed { background: #FDECEA; color: #721C24; }


footer {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background: #f5f5f5; /* light grey / whitish */
    color: #333; /* dark text for contrast */
    text-align: center;
    padding: 12px 0;
    font-size: 14px;
    box-shadow: 0 -3px 10px rgba(0,0,0,0.1);
}

footer a {
    color: #002147; /* optional: make any links dark blue */
    text-decoration: none;
}

@media (max-width: 400px) {
    footer {
        font-size: 12px;
        padding: 10px 0;
    }
}


/* Freeze Top Section */
.top-fixed {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    background: #F4F6F9;
    z-index: 1000;
}

/* Give space so content doesn't hide behind fixed header */
.scroll-area {
    margin-top: 2px; /* Adjust if needed */
    padding: 20px;
}

/* Optional: subtle shadow for premium look */
/*.top-fixed {*/
/*    box-shadow: 0 5px 20px rgba(0,0,0,0.08);*/
/*}*/


.header-right { display:flex; align-items:center; gap:15px; }
.header-right .logout-link { color:#fff; font-size:18px; margin-left:5px; }
.container { padding: 30px 20px 50px 20px; max-width:400px; margin:auto; }
.contribution-list { list-style:none; padding:0; margin:0; }
.contribution-list li { background:#fff; margin-bottom:10px; padding:15px; border-radius:12px; box-shadow:0 4px 15px rgba(0,0,0,0.05); display:flex; justify-content:space-between; font-size:14px; }
.pagination { display:flex; justify-content:center; margin-top:20px; gap:5px; flex-wrap:wrap; }
.pagination a, .pagination span { padding:8px 12px; background:#fff; border-radius:8px; border:1px solid #ddd; color:#333; text-decoration:none; transition:0.3s; }
.pagination a:hover { background:#F58220; color:#fff; }
.pagination .current { background:#C9A227; color:#fff; border-color:#D85C00; }



.card {
    background:#fff;
    padding:15px;
    border-radius:12px;
    box-shadow:0 6px 20px rgba(0,0,0,0.08);
    margin-bottom:20px;
    text-align:center;
}

.card h3 { color:#C9A227; margin-bottom:10px; }
.card span { font-size:18px; font-weight:600; }

form {
    background:#fff;
    padding:20px;
    border-radius:12px;
    box-shadow:0 6px 20px rgba(0,0,0,0.08);
    margin-bottom:20px;
}
form input, form button {
    width:100%;
    padding:12px;
    margin-bottom:15px;
    border-radius:10px;
    border:1px solid #ccc;
    font-size:16px;
    outline:none;
}
form input:focus { border-color:#F58220; box-shadow:0 0 6px rgba(245,130,32,0.3); }
form button {
    background: linear-gradient(135deg, #F58220, #C9A227);
    color:#fff;
    font-weight:600;
    border:none;
    cursor:pointer;
    transition:0.3s;
}
form button:hover { background: linear-gradient(135deg, #D85C00, #F58220); }

#result { font-weight:600; font-size:18px; color:#F58220; }
input {
    width: 80%;
    padding: 12px 15px;
    margin-bottom: 12px;
    border-radius: 8px;
    border: 1px solid #ccc;
    font-size: 16px;
    box-sizing: border-box;
}



</style>
<body>
<div class="sidebar">
    <div class="logo">
        <div style="font-weight:600;">3y3 SUPA</div>
    </div>

    <a href="dashboard.php"><i class="fa-solid fa-gauge"></i><span>Dashboard</span></a>
    <a href="contribute.php"><i class="fa-solid fa-money-bill-wave"></i><span>Contribute</span></a>
    <a href="history.php"><i class="fa-solid fa-clock-rotate-left"></i><span>History</span></a>
    <a href="projection.php" class="active"><i class="fa-solid fa-chart-line"></i><span>Projection</span></a>
    <a href="support.php"><i class="fa-solid fa-headset"></i><span>Support</span></a>
    <a href="beneficiaries.php"><i class="fa-solid fa-users"></i><span>Beneficiaries</span></a>
    <a href="balance.php"><i class="fa-solid fa-wallet"></i><span>Balance</span></a>

    <a href="logout.php" class="">
        <i class="fa-solid fa-right-from-bracket"></i><span>Logout</span>
    </a>
</div>

<div class="main">

<header>
    <div><i class="fa-solid fa-user"></i> <?=htmlspecialchars($user['full_name'])?></div>
</header>

<div class="national-bar">
    <div>3y3 Supa</div>
    <div>Secure Today. Enjoy Tomorrow.</div>
</div>
<div class="container">

    <div class="card">
        <h3>Current Balance</h3>
        <span>₵ <?=number_format($user['balance'],2)?></span>
    </div>

    <div class="card">
        <h3>Total Contributions</h3>
        <span>₵ <?=number_format($total_contrib,2)?></span>
    </div>

    <form onsubmit="calculateSuperannuation(); return false;">
        <input type="number" id="contribution" placeholder="Daily Contribution (₵)" required>
        <input type="number" id="returnRate" placeholder="Annual Return Rate (%)" required>
        <input type="number" id="years" placeholder="Number of Years" required>
        <button type="submit">Calculate Projection</button>
    </form>

    <div class="card">
        <h3>Projected Pension</h3>
        <span id="result">₵ 0.00</span>
    </div>

</div>
</div>
<script>
function calculateSuperannuation() {
    let dailyContribution = parseFloat(document.getElementById('contribution').value) || 0;
    let returnRate = parseFloat(document.getElementById('returnRate').value)/100 || 0;
    let years = parseInt(document.getElementById('years').value) || 0;

    if(dailyContribution <= 0 || returnRate < 0 || years <= 0) {
        alert("Please enter valid values.");
        return;
    }

    let monthlyContribution = dailyContribution * 30; // daily → monthly
    let monthlyRate = returnRate / 12;
    let totalMonths = years * 12;

    // Future Value (annuity formula)
    let futureValue = monthlyContribution * ((Math.pow(1 + monthlyRate, totalMonths) - 1)/monthlyRate);

    document.getElementById('result').textContent = "₵ " + futureValue.toFixed(2);
}
</script>

<footer>
    &copy; <?=date('Y')?> 3y3 Supa. Powered by Tekpulse Consult Ltd.
</footer>

<style>
footer {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background: #f5f5f5; /* light grey / whitish */
    color: #333; /* dark text for contrast */
    text-align: center;
    padding: 12px 0;
    font-size: 14px;
    box-shadow: 0 -3px 10px rgba(0,0,0,0.1);
}

footer a {
    color: #002147; /* optional: make any links dark blue */
    text-decoration: none;
}

@media (max-width: 400px) {
    footer {
        font-size: 12px;
        padding: 10px 0;
    }
}
</style>

</body>
</html>
