<?php
session_start();
include("../config.php");

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

// Fetch user info
$stmt = $conn->prepare("SELECT id, full_name, phone, balance FROM users WHERE id=? LIMIT 1");
$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
$stmt->close();

// Pagination settings
$limit = 8; // records per page
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$offset = ($page - 1) * $limit;

// Count total contributions
$stmt = $conn->prepare("SELECT COUNT(*) as total FROM payments WHERE user_id=?");
$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
$total = $stmt->get_result()->fetch_assoc()['total'] ?? 0;
$stmt->close();
$totalPages = ceil($total / $limit);

// Fetch recent contributions for current user
$stmt = $conn->prepare("
    SELECT id, amount, status, payment_date
    FROM payments 
    WHERE user_id=? 
    ORDER BY payment_date DESC 
    LIMIT 20
");
$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
$contributions = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();


?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>3y3 SUPA History</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>


<style>

/* ===== GLOBAL ===== */
body {
    margin: 0;
    font-family: 'Poppins', sans-serif;
    background: #F4F6F9;
    display: flex;
}

/* ===== SIDEBAR ===== */
.sidebar {
    width: 240px;
    background: #002147;
    color: #fff;
    position: fixed;
    left: 0;
    top: 0;
    bottom: 0;
    display: flex;
    flex-direction: column;
    padding: 20px 0;
}

.sidebar .logo {
    text-align: center;
    margin-bottom: 25px;
}

.sidebar a {
    padding: 14px 25px;
    text-decoration: none;
    color: #fff;
    display: flex;
    align-items: center;
    gap: 12px;
    font-size: 14px;
    transition: 0.3s;
}

.sidebar a:hover,
.sidebar a.active {
    background: #C9A227;
    color: #002147;
    font-weight: 600;
}

/* Push logout to bottom */
.sidebar a.logout {
    margin-top: auto;
}

/* ===== MAIN ===== */
.main {
    margin-left: 240px;
    width: 100%;
    min-height: 100vh;
    display: flex;
    flex-direction: column;
}

/* HEADER */
header {
    background: linear-gradient(135deg, #002147 0%, #001530 100%);
    border-bottom: 4px solid #C9A227;
    padding: 15px 20px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    color: #fff;
}


/* NATIONAL BAR */
.national-bar {
    background: #C9A227;
    color: #002147;
    padding: 8px 30px;
    font-size: 13px;
    font-weight: 600;
    display: flex;
    justify-content: space-between;
}

/* CONTENT CONTAINER (FIXED WIDTH) */
.content {
    max-width: 1100px;
    margin: 30px auto;
    padding: 0 20px;
    width: 100%;
}

.logo-area {
    display: flex;
    align-items: center;
    gap: 12px;
}

.logo-area img {
    height: 45px;
}

.header-right {
    display: flex;
    align-items: center;
    gap: 15px;
}

.logout-link {
    color: #fff;
    font-size: 18px;
}

/* National Bar */
.national-bar {
    background: #C9A227;
    color: #002147;
    padding: 8px 20px;
    font-size: 13px;
    font-weight: 600;
    display: flex;
    justify-content: space-between;
}

/* Container */
.container {
    padding: 0px;
}

/* Executive Panel */
.executive-panel {
    background: #fff;
    border-radius: 16px;
    padding: 20px;
    margin-bottom: 25px;
    display: flex;
    justify-content: space-between;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
}

.exec-item small {
    color: #5A5A5A;
}

.exec-item h3 {
    margin-top: 5px;
    color: #002147;
}

.active-status {
    color: #1E7E34;
}

/* Cards */
.cards {
    display: grid;
    grid-template-columns: repeat(2, 1fr); /* ALWAYS 2 per row */
    gap: 15px;
    margin-bottom: 25px;
}

.card {
    background: #fff;
    border-radius: 18px;
    padding: 16px; /* reduced padding */
    text-align: center;
    border: 1px solid #E5E5E5;
    box-shadow: 0 6px 18px rgba(0,0,0,0.05);
    transition: 0.25s ease;
    cursor: pointer;
    min-height: 120px; /* keeps them compact */
    display: flex;
    flex-direction: column;
    justify-content: center;
}

.card:hover {
    transform: translateY(-4px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
}

.card i {
    font-size: 24px; /* slightly smaller icon */
    color: #C9A227;
    margin-bottom: 8px;
}

.card div {
    font-weight: 600;
    color: #002147;
    font-size: 15px;
}

/* CHART */
.chart-card {
    background: #fff;
    padding: 20px;
    border-radius: 14px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.06);
    margin-bottom: 30px;
    max-width: 750px;
    margin-left: auto;
    margin-right: auto;
}

.chart-wrapper {
    height: 280px;
}

/* CONTRIBUTIONS */
.contribution-list {
    list-style: none;
    padding: 0;
    max-width: 750px;
    margin: 0 auto;
}

.contribution-list li {
    background: #fff;
    margin-bottom: 12px;
    padding: 14px 18px;
    border-radius: 12px;
    display: flex;
    justify-content: space-between;
    box-shadow: 0 4px 15px rgba(0,0,0,0.05);
}

.status {
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
}

.status.success { background: #E6F4EA; color: #1E7E34; }
.status.pending { background: #FFF8E1; color: #856404; }
.status.failed { background: #FDECEA; color: #721C24; }


footer {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background: #f5f5f5; /* light grey / whitish */
    color: #333; /* dark text for contrast */
    text-align: center;
    padding: 12px 0;
    font-size: 14px;
    box-shadow: 0 -3px 10px rgba(0,0,0,0.1);
}

footer a {
    color: #002147; /* optional: make any links dark blue */
    text-decoration: none;
}



/* MOBILE */
@media(max-width: 900px){
    .sidebar {
        width: 70px;
    }

    .sidebar a span {
        display: none;
    }

    .main {
        margin-left: 70px;
    }

    .cards {
        grid-template-columns: 1fr;
    }
}

.header-right { display:flex; align-items:center; gap:15px; }
.header-right .logout-link { color:#fff; font-size:18px; margin-left:5px; }
.container { padding: 90px 20px 50px 20px; max-width:900px; margin:auto; }
.contribution-list { list-style:none; padding:0; margin:0; }
.contribution-list li {
    background: #fff;
    margin-bottom: 12px;
    padding: 18px 22px;
    border-radius: 14px;
    box-shadow: 0 6px 18px rgba(0,0,0,0.06);
    display: flex;
    justify-content: space-between;
    align-items: center;
    font-size: 15px;
    width: 100%;
}
.contribution-list li:hover {
    transform: translateY(-2px);
    transition: 0.2s ease;
}
.pagination { display:flex; justify-content:center; margin-top:20px; gap:5px; flex-wrap:wrap; }
.pagination a, .pagination span { padding:8px 12px; background:#fff; border-radius:8px; border:1px solid #ddd; color:#333; text-decoration:none; transition:0.3s; }
.pagination a:hover { background:#F58220; color:#fff; }
.pagination .current { background:#C9A227; color:#fff; border-color:#D85C00; }

/* ===== TRANSACTION TABLE ===== */

.table-card {
    background: #fff;
    border-radius: 16px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.06);
    padding: 20px;
    width: 100%;
}

.table-header {
    margin-bottom: 15px;
}

.table-header h3 {
    margin: 0;
    color: #002147;
    font-size: 18px;
}

.table-responsive {
    overflow-x: auto;
}

.transaction-table {
    width: 100%;
    border-collapse: collapse;
    font-size: 14px;
}

.transaction-table thead {
    background: #F4F6F9;
}

.transaction-table th {
    text-align: left;
    padding: 14px;
    font-weight: 600;
    color: #002147;
    font-size: 13px;
}

.transaction-table td {
    padding: 16px 14px;
    border-top: 1px solid #eee;
    color: #333;
}

.transaction-table tbody tr:hover {
    background: #FAFBFD;
    transition: 0.2s ease;
}

/* Right aligned amount */
.text-right {
    text-align: right;
    font-weight: 600;
}

/* Status Badges */
.badge {
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
}

.badge.success {
    background: #E6F4EA;
    color: #1E7E34;
}

.badge.pending {
    background: #FFF8E1;
    color: #856404;
}

.badge.failed {
    background: #FDECEA;
    color: #721C24;
}

</style>



<body>

<div class="sidebar">
    <div class="logo">
        <div style="font-weight:600;">3y3 SUPA</div>
    </div>

    <a href="dashboard.php"><i class="fa-solid fa-gauge"></i><span>Dashboard</span></a>
    <a href="contribute.php"><i class="fa-solid fa-money-bill-wave"></i><span>Contribute</span></a>
    <a href="history.php" class="active"><i class="fa-solid fa-clock-rotate-left"></i><span>History</span></a>
    <a href="projection.php"><i class="fa-solid fa-chart-line"></i><span>Projection</span></a>
    <a href="support.php"><i class="fa-solid fa-headset"></i><span>Support</span></a>
    <a href="beneficiaries.php"><i class="fa-solid fa-users"></i><span>Beneficiaries</span></a>
    <a href="balance.php"><i class="fa-solid fa-wallet"></i><span>Balance</span></a>

    <a href="logout.php" class="">
        <i class="fa-solid fa-right-from-bracket"></i><span>Logout</span>
    </a>
</div>

<div class="main">

<header>
    <div><i class="fa-solid fa-user"></i> <?=htmlspecialchars($user['full_name'])?></div>
</header>

<div class="national-bar">
    <div>3y3 Supa</div>
    <div>Secure Today. Enjoy Tomorrow.</div>
</div>

<div class="container">

        <!-- Contributions -->
    <div class="section">
        <!--<h2>Recent Contributions</h2>-->
       <div class="table-card">
    <div class="table-header">
        <h3>Contribution History</h3>
    </div>

    <div class="table-responsive">
        <table class="transaction-table">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Reference</th>
                    <th>Method</th>
                    <th class="text-right">Amount (GHS)</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php if(!empty($contributions)): ?>
                    <?php foreach($contributions as $c): ?>
                        <tr>
                            <td><?= date('d M Y', strtotime($c['payment_date'])) ?></td>
                            <td><?= 'TXN-' . str_pad($c['id'], 6, '0', STR_PAD_LEFT) ?></td>
                            <td><?= htmlspecialchars($c['payment_method'] ?? 'MoMo') ?></td>
                            <td class="text-right"><?= number_format($c['amount'],2) ?></td>
                            <td>
                                <span class="badge <?= strtolower($c['status']) ?>">
                                    <?= ucfirst($c['status']) ?>
                                </span>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5" style="text-align:center; padding:20px;">No contributions yet</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
    </div>

    <?php if($totalPages > 1): ?>
        <div class="pagination">
            <?php if($page > 1): ?>
                <a href="?page=<?=($page-1)?>">&laquo; Prev</a>
            <?php endif; ?>

            <?php for($i=1; $i <= $totalPages; $i++): ?>
                <?php if($i == $page): ?>
                    <span class="current"><?=$i?></span>
                <?php else: ?>
                    <a href="?page=<?=$i?>"><?=$i?></a>
                <?php endif; ?>
            <?php endfor; ?>

            <?php if($page < $totalPages): ?>
                <a href="?page=<?=($page+1)?>">Next &raquo;</a>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>
</div>
<footer>
    &copy; <?=date('Y')?> 3y3 Supa. Powered by Tekpulse Consult Ltd.
</footer>

<style>
footer {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background: #f5f5f5; /* light grey / whitish */
    color: #333; /* dark text for contrast */
    text-align: center;
    padding: 12px 0;
    font-size: 14px;
    box-shadow: 0 -3px 10px rgba(0,0,0,0.1);
}

footer a {
    color: #002147; /* optional: make any links dark blue */
    text-decoration: none;
}

@media (max-width: 400px) {
    footer {
        font-size: 12px;
        padding: 10px 0;
    }
}
</style>

</body>
</html>
