<?php
include('../config.php');
session_start();
$user_id = $_SESSION['user_id'] ?? null;
if (!$user_id) { header("Location: login.php"); exit; }

// Fetch user details
$stmt = $conn->prepare("SELECT id, full_name, phone, balance FROM users WHERE id=? LIMIT 1");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
$stmt->close();

// Fetch recent contributions (last 5)
$stmt = $conn->prepare("SELECT amount, status, payment_date FROM payments WHERE user_id=? ORDER BY payment_date DESC LIMIT 5");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$contributions = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>EdwumaSupa Mobile</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
<style>
/* Reset and body */
body {
    margin: 0;
    font-family: 'Poppins', sans-serif;
    background: #F9F9F9;
    color: #000;
    transition: margin-left 0.3s;
    overflow-x: hidden;
}

/* Header / Topbar */
header {
    background: linear-gradient(135deg, #F58220 0%, #D85C00 100%);
    padding: 15px 20px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    color: #fff;
    position: fixed;
    width: 100%;
    top: 0;
    z-index: 1001;
}
.hamburger { font-size: 22px; cursor: pointer; }
.header-right { display: flex; align-items: center; gap: 10px; }
.user-name { white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
.logout-link { color: #fff; font-size: 18px; }

/* Sidebar */
.sidebar {
    position: fixed;
    top: 0;
    left: 0;
    width: 250px;
    height: 100%;
    background: #fff;
    box-shadow: 2px 0 12px rgba(0,0,0,0.1);
    padding: 20px;
    transition: transform 0.3s ease;
    z-index: 1000;
    transform: translateX(-100%);
}
.sidebar.active { transform: translateX(0); }
.sidebar h2 { color: #D85C00; margin-bottom: 20px; }
.sidebar ul { list-style: none; padding: 0; margin: 0; }
.sidebar ul li { padding: 12px 0; border-bottom: 1px solid #eee; cursor: pointer; }
.sidebar ul li:hover { color: #F58220; }

/* Overlay */
.overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 0;
    height: 100%;
    background: rgba(0,0,0,0.4);
    transition: opacity 0.3s ease, width 0s linear 0.3s;
    opacity: 0;
    z-index: 999;
}
.overlay.active {
    width: 100%;
    opacity: 1;
    transition: opacity 0.3s ease;
}

/* Main container */
.container {
    padding: 100px 20px 20px 20px;
    transition: margin-left 0.3s;
}
.container.shift { margin-left: 250px; }

/* Cards grid */
.cards {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    gap: 20px;
    margin-bottom: 20px;
}
.card {
    background: #fff;
    border-radius: 16px;
    padding: 20px;
    text-align: center;
    box-shadow: 0 8px 25px rgba(0,0,0,0.08);
    cursor: pointer;
    transition: 0.3s;
}
.card:hover { transform: translateY(-5px); box-shadow: 0 12px 30px rgba(0,0,0,0.15); }
.card i { font-size: 30px; color: #F58220; margin-bottom: 10px; }
.card span { display: block; font-weight: 600; font-size: 16px; }

/* Sections */
.section h2 { font-size: 18px; margin-bottom: 15px; color: #D85C00; }
.contribution-list { list-style: none; padding: 0; margin: 0; }
.contribution-list li {
    background: #fff;
    margin-bottom: 10px;
    padding: 15px;
    border-radius: 12px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.05);
    display: flex;
    justify-content: space-between;
    font-size: 14px;
}

/* Responsive */
@media(max-width: 768px){
    .container.shift { margin-left: 0; }
    .card i { font-size: 24px; }
    .card span { font-size: 14px; }
}
</style>
</head>
<body>

<header>
    <div class="hamburger" onclick="toggleSidebar()"><i class="fa-solid fa-bars"></i></div>
    <div class="header-right">
        <span class="user-name"><i class="fa-solid fa-user"></i> <?=htmlspecialchars($user['full_name'])?></span>
        <a href="logout.php" class="logout-link"><i class="fa-solid fa-right-from-bracket"></i></a>
    </div>
</header>

<div class="sidebar" id="sidebar">
    <h2>Menu</h2>
    <ul>
        <li onclick="window.location='dashboard.php'">Home</li>
        <li onclick="window.location='contribute.php'">Contribute</li>
        <li onclick="window.location='balance.php'">My Balance</li>
        <li onclick="window.location='history.php'">History</li>
        <li onclick="window.location='projection.php'">Projection</li>
        <li onclick="window.location='beneficiaries.php'">Beneficiaries</li>
        <li onclick="window.location='support.php'">Support</li>
        <li onclick="window.location='logout.php'">Logout</li>
    </ul>
</div>

<div class="overlay" id="overlay" onclick="toggleSidebar()"></div>

<div class="container" id="container">

    <!-- Cards -->
    <div class="cards">
        <div class="card" onclick="window.location='contribute.php'">
            <i class="fa-solid fa-money-bill-wave"></i>
            <span>₵ Contribute</span>
        </div>
        <div class="card" onclick="window.location='balance.php'">
            <i class="fa-solid fa-wallet"></i>
            <span>Balance (₵ <?=number_format($user['balance'],2)?>)</span>
        </div>
        <div class="card" onclick="window.location='history.php'">
            <i class="fa-solid fa-clock-rotate-left"></i>
            <span>History</span>
        </div>
        <div class="card" onclick="window.location='projection.php'">
            <i class="fa-solid fa-chart-line"></i>
            <span>Projection</span>
        </div>
        <div class="card" onclick="window.location='beneficiaries.php'">
            <i class="fa-solid fa-users"></i>
            <span>Beneficiaries</span>
        </div>
        <div class="card" onclick="window.location='support.php'">
            <i class="fa-solid fa-headset"></i>
            <span>Support</span>
        </div>
    </div>

    <!-- Contributions list -->
    <div class="section">
        <h2>Recent Contributions</h2>
        <ul class="contribution-list">
            <?php if(!empty($contributions)): ?>
                <?php foreach($contributions as $c): ?>
                    <li>
                        <span><?=ucfirst($c['payment_date'])?></span>
                        <span>₵ <?=number_format($c['amount'],2)?></span> 
                        <span><?=ucfirst($c['status'])?></span>
                        
                    </li>
                <?php endforeach; ?>
            <?php else: ?>
                <li>No contributions yet</li>
            <?php endif; ?>
        </ul>
    </div>

</div>

<script>
function toggleSidebar() {
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('overlay');
    const container = document.getElementById('container');
    
    sidebar.classList.toggle('active');
    overlay.classList.toggle('active');

    if(window.innerWidth > 768){
        container.classList.toggle('shift');
    }
}
</script>

<footer>
    &copy; <?=date('Y')?> 3y3 Supa. Powered by Tekpulse Consult Ltd.
</footer>

<style>
footer {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background: #f5f5f5; /* light grey / whitish */
    color: #333; /* dark text for contrast */
    text-align: center;
    padding: 12px 0;
    font-size: 14px;
    box-shadow: 0 -3px 10px rgba(0,0,0,0.1);
}

footer a {
    color: #002147; /* optional: make any links dark blue */
    text-decoration: none;
}

@media (max-width: 400px) {
    footer {
        font-size: 12px;
        padding: 10px 0;
    }
}
</style>


</body>
</html>
