<?php
// ssnit_export.php
// Export all users without SSNIT numbers to CSV and optionally email

include("config.php"); // uses $conn from config.php
date_default_timezone_set('Africa/Accra');

// --- Configuration ---
$sendEmail = true;
$recipientEmail = "ssnit@agency.gov.gh"; // SSNIT email
$emailSubject = "SSNIT Users Export - " . date('Y-m-d H:i:s');
$emailFrom = "no-reply@tekpulse.com";
$emailBody = "Please find attached the latest export of users without SSNIT numbers.";

// --- Folder & File creation ---
$exportDir = __DIR__ . '/ssnit_export';

// Make sure the folder exists
if (!is_dir($exportDir)) {
    mkdir($exportDir, 0755, true);
}

// Create export file path
$exportFile = $exportDir . '/ssnit_export_' . date('Ymd_His') . '.csv';
$fp = fopen($exportFile, 'w');
if (!$fp) die("Unable to create export file: $exportFile");

// Add CSV header
fputcsv($fp, ['user_id','full_name','dob','gender','phone_number','email']);

// Query users without SSNIT and completed assignment
$sql = "SELECT id, full_name, dob, gender, phone, email 
        FROM users 
        WHERE ssnit_number IS NULL 
          AND assignment_status = 'completed'";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        fputcsv($fp, [
            $row['id'],
            $row['full_name'],
            $row['dob'] ?? '',
            $row['gender'] ?? '',
            $row['phone'] ?? '',
            $row['email'] ?? ''
        ]);
    }
}

fclose($fp);
$conn->close();

echo "Export completed: $exportFile" . PHP_EOL;

// --- Email the CSV ---
if ($sendEmail) {
    $fileContent = file_get_contents($exportFile);
    $separator = md5(time());
    $eol = PHP_EOL;

    $headers  = "From: $emailFrom" . $eol;
    $headers .= "MIME-Version: 1.0" . $eol;
    $headers .= "Content-Type: multipart/mixed; boundary=\"" . $separator . "\"" . $eol;

    $body = "--$separator" . $eol;
    $body .= "Content-Type: text/plain; charset=\"utf-8\"" . $eol;
    $body .= "Content-Transfer-Encoding: 7bit" . $eol . $eol;
    $body .= $emailBody . $eol;

    $body .= "--$separator" . $eol;
    $body .= "Content-Type: text/csv; name=\"" . basename($exportFile) . "\"" . $eol;
    $body .= "Content-Transfer-Encoding: base64" . $eol;
    $body .= "Content-Disposition: attachment; filename=\"" . basename($exportFile) . "\"" . $eol . $eol;
    $body .= chunk_split(base64_encode($fileContent)) . $eol;
    $body .= "--$separator--";

    if (mail($recipientEmail, $emailSubject, $body, $headers)) {
        echo "Email sent to $recipientEmail" . PHP_EOL;
    } else {
        echo "Failed to send email." . PHP_EOL;
    }
}
?>
