<?php
include('../config.php');
session_start();

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = trim($_POST['full_name'] ?? '');
    $phone = preg_replace('/\D/', '', $_POST['phone'] ?? '');
    $pin = $_POST['pin'] ?? '';
    $network = trim($_POST['network'] ?? '');

    if (!$full_name || !$phone || !$pin || !$network) {
        $error = "All fields are required";
    } elseif (!preg_match('/^\d{4,6}$/', $pin)) {
        $error = "PIN must be 4-6 digits";
    } else {
        // Normalize phone number: convert 0XXXX... to 233XXXX...
        if (strlen($phone) == 10 && substr($phone, 0, 1) == '0') {
            $phone = '233' . substr($phone, 1);
        }

        // Check if phone already exists
        $stmt = $conn->prepare("SELECT id FROM users WHERE phone=? LIMIT 1");
        $stmt->bind_param("s", $phone);
        $stmt->execute();
        $existing = $stmt->get_result()->fetch_assoc();
        $stmt->close();

        if ($existing) {
            $error = "Phone number already registered";
        } else {
            // Insert new user
            $hashed_pin = password_hash($pin, PASSWORD_DEFAULT);
            $stmt = $conn->prepare("INSERT INTO users (full_name, phone, pin, network, balance, registration_channel) VALUES (?, ?, ?, ?, 0, ?)");
            $registration_channel = 'WEB';
            $stmt->bind_param("sssss", $full_name, $phone, $hashed_pin, $network, $registration_channel);

            if ($stmt->execute()) {
                $success = "Registration successful! You can now login.";
                // Optionally clear the form fields
                $full_name = $phone = $pin = $network = '';
            } else {
                $error = "Registration failed. Please try again.";
            }
            $stmt->close();
        }
    }
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>EdwumaSupa - Register</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
<style>
body { margin:0; font-family:'Poppins',sans-serif; background:#F9F9F9; }
header { background: linear-gradient(135deg,#F58220 0%,#D85C00 100%); color:#fff; padding:15px 20px; text-align:center; font-size:1.5rem; }
.container { padding:20px; max-width:500px; margin:80px auto 20px auto; }
.card { background:#fff; border-radius:12px; padding:20px; margin-bottom:15px; text-align:center; box-shadow:0 6px 20px rgba(0,0,0,0.1); transition:0.3s; }
.card:hover { transform:translateY(-3px); box-shadow:0 10px 25px rgba(0,0,0,0.15); }
input, button { width:100%; padding:12px 15px; margin-bottom:12px; border-radius:8px; border:1px solid #ccc; font-size:16px; box-sizing:border-box; }
button { background:#F58220; color:#fff; border:none; cursor:pointer; transition:0.3s; }
button:hover { background:#D85C00; }
.success { color:green; text-align:center; margin-bottom:15px; font-size:14px; }
.error { color:red; text-align:center; margin-bottom:15px; font-size:14px; }
a { color:#F58220; text-decoration:none; }
a:hover { text-decoration:underline; }
@media(max-width:400px){ .container { margin:80px 10px 20px 10px; } input, button { font-size:14px; padding:10px 12px; } }

input {
    width: 100%;
    padding: 12px 15px;
    margin-bottom: 12px;
    border-radius: 8px;
    border: 1px solid #ccc;
    font-size: 16px;
    box-sizing: border-box;
}

select {
    width: 100%;
    padding: 12px 15px;
    margin-bottom: 12px;
    border-radius: 8px;
    border: 1px solid #ccc;
    font-size: 16px;
    box-sizing: border-box;
    appearance: none; /* remove default arrow */
    -webkit-appearance: none;
    -moz-appearance: none;
    background: #fff url("data:image/svg+xml;charset=US-ASCII,%3Csvg%20width%3D%2210%22%20height%3D%227%22%20viewBox%3D%220%200%2010%207%22%20xmlns%3D%22http://www.w3.org/2000/svg%22%3E%3Cpath%20d%3D%22M0%200l5%207%205-7H0z%22%20fill%3D%22%23666%22/%3E%3C/svg%3E") no-repeat right 12px center;
    background-size: 10px 7px;
}


</style>
</head>
<body>

<header>3y3 Supa</header>

<div class="container">

    <div class="card">
        <h2><font color='#F58220'>Join 3y3 Supa Today</font></h2>

        <?php if($success): ?>
            <div class="success"><?=htmlspecialchars($success)?></div>
        <?php endif; ?>
        <?php if($error): ?>
            <div class="error"><?=htmlspecialchars($error)?></div>
        <?php endif; ?>

       <form method="POST" action="">
    <input type="text" name="full_name" placeholder="Full Name" required>
    <input type="tel" name="phone" placeholder="Phone Number" required>
    <input type="password" name="pin" placeholder="PIN (4-6 digits)" required>
    <select name="network" required>
        <option value="">Select Network</option>
        <option value="MTN">MTN</option>
        <option value="Vodafone">Vodafone</option>
        <option value="AirtelTigo">AirtelTigo</option>
    </select>
    <button type="submit">Register</button>
</form>

        <p style="text-align:center; margin-top:10px;">
            Already registered? <a href="login.php">Login here</a>
        </p>
    </div>

</div>

<footer>
    &copy; <?=date('Y')?> 3y3 Supa. Powered by Tekpulse Consult Ltd.
</footer>

<style>
footer {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background: #f5f5f5; /* light grey / whitish */
    color: #333; /* dark text for contrast */
    text-align: center;
    padding: 12px 0;
    font-size: 14px;
    box-shadow: 0 -3px 10px rgba(0,0,0,0.1);
}

footer a {
    color: #002147; /* optional: make any links dark blue */
    text-decoration: none;
}

@media (max-width: 400px) {
    footer {
        font-size: 12px;
        padding: 10px 0;
    }
}
</style>

</body>
</html>
