<?php
// projection.php
include('../config.php');
session_start();

$user_id = $_SESSION['user_id'] ?? null;
if (!$user_id) { 
    header("Location: login.php"); 
    exit; 
}

// Fetch user info
$stmt = $conn->prepare("SELECT full_name, balance FROM users WHERE id=? LIMIT 1");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
$stmt->close();

// Fetch total contributions
$stmt = $conn->prepare("SELECT SUM(amount) as total_contrib FROM payments WHERE user_id=? AND status='success'");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$totalRow = $stmt->get_result()->fetch_assoc();
$total_contrib = floatval($totalRow['total_contrib'] ?? 0);
$stmt->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Pension Projection - EdwumaSupa</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
<style>
body {
    font-family: 'Poppins', sans-serif;
    background: #F9F9F9;
    margin:0; padding:0; color:#000;
}
header {
    background: linear-gradient(135deg, #F58220 0%, #D85C00 100%);
    padding:15px 20px;
    color:#fff;
    display:flex;
    justify-content:space-between;
    align-items:center;
    position:fixed;
    width:100%;
    top:0;
    z-index:1001;
}
header h1 { font-size:18px; margin:0; }
.header-right { display:flex; align-items:center; gap:15px; }
.header-right .logout-link { color:#fff; font-size:18px; margin-left:5px; }

.container {
    padding: 90px 20px 20px 20px;
    max-width:400px;
    margin:auto;
}

.card {
    background:#fff;
    padding:15px;
    border-radius:12px;
    box-shadow:0 6px 20px rgba(0,0,0,0.08);
    margin-bottom:20px;
    text-align:center;
}

.card h3 { color:#D85C00; margin-bottom:10px; }
.card span { font-size:18px; font-weight:600; }

form {
    background:#fff;
    padding:20px;
    border-radius:12px;
    box-shadow:0 6px 20px rgba(0,0,0,0.08);
    margin-bottom:20px;
}
form input, form button {
    width:100%;
    padding:12px;
    margin-bottom:15px;
    border-radius:10px;
    border:1px solid #ccc;
    font-size:16px;
    outline:none;
}
form input:focus { border-color:#F58220; box-shadow:0 0 6px rgba(245,130,32,0.3); }
form button {
    background: linear-gradient(135deg, #F58220, #D85C00);
    color:#fff;
    font-weight:600;
    border:none;
    cursor:pointer;
    transition:0.3s;
}
form button:hover { background: linear-gradient(135deg, #D85C00, #F58220); }

#result { font-weight:600; font-size:18px; color:#F58220; }
input {
    width: 80%;
    padding: 12px 15px;
    margin-bottom: 12px;
    border-radius: 8px;
    border: 1px solid #ccc;
    font-size: 16px;
    box-sizing: border-box;
}
</style>
</head>
<body>

<header>
    <div class="back" onclick="window.location='index.php'"><i class="fa-solid fa-arrow-left"></i></div>
    <div class="header-right">
        <span><i class="fa-solid fa-user"></i> <?=htmlspecialchars($user['full_name'])?></span>
        <a href="logout.php" class="logout-link"><i class="fa-solid fa-right-from-bracket"></i></a>
    </div>
</header>

<div class="container">

    <div class="card">
        <h3>Current Balance</h3>
        <span>₵ <?=number_format($user['balance'],2)?></span>
    </div>

    <div class="card">
        <h3>Total Contributions</h3>
        <span>₵ <?=number_format($total_contrib,2)?></span>
    </div>

    <form onsubmit="calculateSuperannuation(); return false;">
        <input type="number" id="contribution" placeholder="Daily Contribution (₵)" required>
        <input type="number" id="returnRate" placeholder="Annual Return Rate (%)" required>
        <input type="number" id="years" placeholder="Number of Years" required>
        <button type="submit">Calculate Projection</button>
    </form>

    <div class="card">
        <h3>Projected Pension</h3>
        <span id="result">₵ 0.00</span>
    </div>

</div>

<script>
function calculateSuperannuation() {
    let dailyContribution = parseFloat(document.getElementById('contribution').value) || 0;
    let returnRate = parseFloat(document.getElementById('returnRate').value)/100 || 0;
    let years = parseInt(document.getElementById('years').value) || 0;

    if(dailyContribution <= 0 || returnRate < 0 || years <= 0) {
        alert("Please enter valid values.");
        return;
    }

    let monthlyContribution = dailyContribution * 30; // daily → monthly
    let monthlyRate = returnRate / 12;
    let totalMonths = years * 12;

    // Future Value (annuity formula)
    let futureValue = monthlyContribution * ((Math.pow(1 + monthlyRate, totalMonths) - 1)/monthlyRate);

    document.getElementById('result').textContent = "₵ " + futureValue.toFixed(2);
}
</script>

<footer>
    &copy; <?=date('Y')?> 3y3 Supa. Powered by Tekpulse Consult Ltd.
</footer>

<style>
footer {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background: #f5f5f5; /* light grey / whitish */
    color: #333; /* dark text for contrast */
    text-align: center;
    padding: 12px 0;
    font-size: 14px;
    box-shadow: 0 -3px 10px rgba(0,0,0,0.1);
}

footer a {
    color: #002147; /* optional: make any links dark blue */
    text-decoration: none;
}

@media (max-width: 400px) {
    footer {
        font-size: 12px;
        padding: 10px 0;
    }
}
</style>

</body>
</html>
