<?php
session_start();
include("../config.php");

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

// Fetch user info
$stmt = $conn->prepare("SELECT id, full_name, phone, balance FROM users WHERE id=? LIMIT 1");
$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
$stmt->close();

// Pagination settings
$limit = 8; // records per page
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$offset = ($page - 1) * $limit;

// Count total contributions
$stmt = $conn->prepare("SELECT COUNT(*) as total FROM payments WHERE user_id=?");
$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
$total = $stmt->get_result()->fetch_assoc()['total'] ?? 0;
$stmt->close();
$totalPages = ceil($total / $limit);

// Fetch contributions for current page
$stmt = $conn->prepare("
    SELECT amount, status, payment_date
    FROM payments
    WHERE user_id=?
    ORDER BY payment_date DESC
    LIMIT ?, ?
");
$stmt->bind_param("iii", $_SESSION['user_id'], $offset, $limit);
$stmt->execute();
$contributions = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();

?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Contribution History - EdwumaSupa</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
<style>
body { margin: 0; font-family: 'Poppins', sans-serif; background: #F9F9F9; color: #000; }
header { background: linear-gradient(135deg, #F58220 0%, #D85C00 100%); padding: 15px 20px; display:flex; justify-content: space-between; align-items:center; color:#fff; position:fixed; width:100%; top:0; z-index:1001; }
.header-right { display:flex; align-items:center; gap:10px; }
.user-name { white-space: nowrap; overflow:hidden; text-overflow: ellipsis; }
.logout-link { color:#fff; font-size:18px; }
.container { padding:100px 20px 20px 20px; max-width:600px; margin:auto; }
.contribution-list { list-style:none; padding:0; margin:0; }
.contribution-list li { background:#fff; margin-bottom:10px; padding:15px; border-radius:12px; box-shadow:0 4px 15px rgba(0,0,0,0.05); display:flex; justify-content:space-between; font-size:14px; }
.pagination { display:flex; justify-content:center; margin-top:20px; gap:5px; flex-wrap:wrap; }
.pagination a, .pagination span { padding:8px 12px; background:#fff; border-radius:8px; border:1px solid #ddd; color:#333; text-decoration:none; transition:0.3s; }
.pagination a:hover { background:#F58220; color:#fff; }
.pagination .current { background:#D85C00; color:#fff; border-color:#D85C00; }
</style>
</head>
<body>

<header>
    <div class="back" onclick="window.location='dashboard.php'"><i class="fa-solid fa-arrow-left"></i></div>
    <div class="header-right">
        <span class="user-name"><i class="fa-solid fa-user"></i> <?=htmlspecialchars($user['full_name'] ?? 'User')?></span>
        <a href="logout.php" class="logout-link"><i class="fa-solid fa-right-from-bracket"></i></a>
    </div>
</header>

<div class="container">
    <!--<h2>Contribution History</h2>-->
    <ul class="contribution-list">
        <?php if(!empty($contributions)): ?>
            <?php foreach($contributions as $c): ?>
                <li>
                    <span>₵ <?=number_format($c['amount'],2)?></span>
                    <span><?=ucfirst($c['status'])?></span>
                    <span><?=date("d M Y, H:i", strtotime($c['payment_date']))?></span>
                </li>
            <?php endforeach; ?>
        <?php else: ?>
            <li>No contributions yet</li>
        <?php endif; ?>
    </ul>

    <?php if($totalPages > 1): ?>
        <div class="pagination">
            <?php if($page > 1): ?>
                <a href="?page=<?=($page-1)?>">&laquo; Prev</a>
            <?php endif; ?>

            <?php for($i=1; $i <= $totalPages; $i++): ?>
                <?php if($i == $page): ?>
                    <span class="current"><?=$i?></span>
                <?php else: ?>
                    <a href="?page=<?=$i?>"><?=$i?></a>
                <?php endif; ?>
            <?php endfor; ?>

            <?php if($page < $totalPages): ?>
                <a href="?page=<?=($page+1)?>">Next &raquo;</a>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>

<footer>
    &copy; <?=date('Y')?> 3y3 Supa. Powered by Tekpulse Consult Ltd.
</footer>

<style>
footer {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background: #f5f5f5; /* light grey / whitish */
    color: #333; /* dark text for contrast */
    text-align: center;
    padding: 12px 0;
    font-size: 14px;
    box-shadow: 0 -3px 10px rgba(0,0,0,0.1);
}

footer a {
    color: #002147; /* optional: make any links dark blue */
    text-decoration: none;
}

@media (max-width: 400px) {
    footer {
        font-size: 12px;
        padding: 10px 0;
    }
}
</style>

</body>
</html>
