<?php
include('../config.php');
session_start();
$user_id = $_SESSION['user_id'] ?? null;
if (!$user_id) { header("Location: login.php"); exit; }

// Fetch user details
$stmt = $conn->prepare("SELECT id, full_name, phone, balance FROM users WHERE id=? LIMIT 1");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
$stmt->close();

// Fetch recent contributions
$stmt = $conn->prepare("SELECT amount, status, payment_date FROM payments WHERE user_id=? ORDER BY payment_date DESC LIMIT 5");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$contributions = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>3y3 SUPA Dashboard</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<style>
body {
    margin: 0;
    font-family: 'Poppins', sans-serif;
    background: #F4F6F9;
}

/* HEADER */
header {
    background: linear-gradient(135deg, #002147 0%, #001530 100%);
    border-bottom: 4px solid #C9A227;
    padding: 15px 20px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    color: #fff;
}

.logo-area {
    display: flex;
    align-items: center;
    gap: 12px;
}

.logo-area img {
    height: 45px;
}

.header-right {
    display: flex;
    align-items: center;
    gap: 15px;
}

.logout-link {
    color: #fff;
    font-size: 18px;
}

/* National Bar */
.national-bar {
    background: #C9A227;
    color: #002147;
    padding: 8px 20px;
    font-size: 13px;
    font-weight: 600;
    display: flex;
    justify-content: space-between;
}

/* Container */
.container {
    padding: 25px;
}

/* Executive Panel */
.executive-panel {
    background: #fff;
    border-radius: 16px;
    padding: 20px;
    margin-bottom: 25px;
    display: flex;
    justify-content: space-between;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
}

.exec-item small {
    color: #5A5A5A;
}

.exec-item h3 {
    margin-top: 5px;
    color: #002147;
}

.active-status {
    color: #1E7E34;
}

/* Cards */
.cards {
    display: grid;
    grid-template-columns: repeat(2, 1fr); /* ALWAYS 2 per row */
    gap: 15px;
    margin-bottom: 25px;
}

.card {
    background: #fff;
    border-radius: 18px;
    padding: 16px; /* reduced padding */
    text-align: center;
    border: 1px solid #E5E5E5;
    box-shadow: 0 6px 18px rgba(0,0,0,0.05);
    transition: 0.25s ease;
    cursor: pointer;
    min-height: 120px; /* keeps them compact */
    display: flex;
    flex-direction: column;
    justify-content: center;
}

.card:hover {
    transform: translateY(-4px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
}

.card i {
    font-size: 24px; /* slightly smaller icon */
    color: #C9A227;
    margin-bottom: 8px;
}

.card div {
    font-weight: 600;
    color: #002147;
    font-size: 15px;
}


/* Chart */
.chart-card {
    background: #fff;
    padding: 20px;
    border-radius: 16px;
    margin-bottom: 25px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.08);
}

/* Contributions */
.section h2 {
    color: #002147;
}

.contribution-list {
    list-style: none;
    padding: 0;
}

.contribution-list li {
    background: #fff;
    margin-bottom: 10px;
    padding: 15px;
    border-radius: 12px;
    display: flex;
    justify-content: space-between;
    box-shadow: 0 4px 15px rgba(0,0,0,0.05);
}

.status {
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
}

.status.success { background: #E6F4EA; color: #1E7E34; }
.status.pending { background: #FFF8E1; color: #856404; }
.status.failed { background: #FDECEA; color: #721C24; }


footer {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background: #f5f5f5; /* light grey / whitish */
    color: #333; /* dark text for contrast */
    text-align: center;
    padding: 12px 0;
    font-size: 14px;
    box-shadow: 0 -3px 10px rgba(0,0,0,0.1);
}

footer a {
    color: #002147; /* optional: make any links dark blue */
    text-decoration: none;
}

@media (max-width: 400px) {
    footer {
        font-size: 12px;
        padding: 10px 0;
    }
}


/* Freeze Top Section */
.top-fixed {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    background: #F4F6F9;
    z-index: 1000;
}

/* Give space so content doesn't hide behind fixed header */
.scroll-area {
    margin-top: 2px; /* Adjust if needed */
    padding: 20px;
}

/* Optional: subtle shadow for premium look */
/*.top-fixed {*/
/*    box-shadow: 0 5px 20px rgba(0,0,0,0.08);*/
/*}*/

</style>
</head>

<body>
<header>
    <div class="logo-area">
        <img src="assets/logo.png" alt="3y3 SUPA Logo">
        <strong>3y3 SUPA</strong>
    </div>

    <div class="header-right">
        <span><i class="fa-solid fa-user"></i> <?=htmlspecialchars($user['full_name'])?></span>
        <a href="logout.php" class="logout-link">
            <i class="fa-solid fa-right-from-bracket"></i>
        </a>
    </div>
</header>

<div class="national-bar">
    <div>3y3 Supa</div>
    <div>Secure Today. Enjoy Tomorrow.</div>
</div>

<div class="container">

    <!-- Executive Panel -->
    <div class="executive-panel">
        <div class="exec-item">
            <small>Member ID</small>
            <h4>3YS-<?=str_pad($user['id'],6,'0',STR_PAD_LEFT)?></h4>
        </div>

        <div class="exec-item">
            <small>Total Contributions</small>
            <h4>₵ <?=number_format($user['balance'],2)?></h4>
        </div>

        <div class="exec-item">
            <small>Status</small>
            <h4 class="active-status">Active</h4>
        </div>
    </div>

    <!-- Action Cards -->
    <div class="cards">
        <div class="card" onclick="window.location='contribute.php'">
            <i class="fa-solid fa-money-bill-wave"></i>
            <div>Contribute</div>
        </div>
        <div class="card" onclick="window.location='history.php'">
            <i class="fa-solid fa-clock-rotate-left"></i>
            <div>History</div>
        </div>
        <div class="card" onclick="window.location='projection.php'">
            <i class="fa-solid fa-chart-line"></i>
            <div>Projection</div>
        </div>
        <div class="card" onclick="window.location='support.php'">
            <i class="fa-solid fa-headset"></i>
            <div>Support</div>
        </div>
    </div>

    <!-- Projection Chart -->
    <div class="chart-card">
        <h3>Pension Growth Projection</h3>
        <canvas id="growthChart"></canvas>
    </div>

    <!-- Contributions -->
    <div class="section">
        <h2>Recent Contributions</h2>
        <ul class="contribution-list">
            <?php if(!empty($contributions)): ?>
                <?php foreach($contributions as $c): ?>
                    <li>
                        <div>
                            <strong>₵ <?=number_format($c['amount'],2)?></strong>
                            <br>
                            <small><?=date('d M Y', strtotime($c['payment_date']))?></small>
                        </div>
                        <span class="status <?=strtolower($c['status'])?>">
                            <?=ucfirst($c['status'])?>
                        </span>
                    </li>
                <?php endforeach; ?>
            <?php else: ?>
                <li>No contributions yet</li>
            <?php endif; ?>
        </ul>
    </div>

</div>

<footer>
    &copy; <?=date('Y')?> 3y3 SUPA | Secure Today. Enjoy Tomorrow.
</footer>

<script>
const ctx = document.getElementById('growthChart');

new Chart(ctx, {
    type: 'line',
    data: {
        labels: ['Year 1','Year 2','Year 3','Year 4','Year 5'],
        datasets: [{
            data: [1000, 3000, 5500, 8000, 12000],
            borderColor: '#002147',
            backgroundColor: 'rgba(201,162,39,0.2)',
            fill: true,
            tension: 0.3
        }]
    },
    options: {
        plugins: { legend: { display: false } }
    }
});
</script>

</body>
</html>
