<?php
include("../config.php");
session_start();

// Check login
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// Fetch logged-in user
$stmt = $conn->prepare("SELECT id, full_name, phone FROM users WHERE id=? LIMIT 1");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
$stmt->close();

$success = $error = "";

/* ==========================
   ADD BENEFICIARY
========================== */
if (isset($_POST['add'])) {
    $name = trim($_POST['name']);
    $phone = trim($_POST['phone']);
    $relationship = trim($_POST['relationship']);

    if ($name && $phone && $relationship) {
        $stmt = $conn->prepare("INSERT INTO beneficiaries (user_id, name, phone, relationship) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("isss", $user_id, $name, $phone, $relationship);
        $stmt->execute();
        $stmt->close();

        $success = "Beneficiary added successfully.";
    } else {
        $error = "All fields are required.";
    }
}

/* ==========================
   DELETE BENEFICIARY
========================== */
if (isset($_GET['delete'])) {
    $bid = intval($_GET['delete']);
    $stmt = $conn->prepare("DELETE FROM beneficiaries WHERE id=? AND user_id=?");
    $stmt->bind_param("ii", $bid, $user_id);
    $stmt->execute();
    $stmt->close();

    $success = "Beneficiary removed successfully.";
}

/* ==========================
   UPDATE BENEFICIARY
========================== */
if (isset($_POST['update'])) {
    $bid = intval($_POST['bid']);
    $name = trim($_POST['name']);
    $phone = trim($_POST['phone']);
    $relationship = trim($_POST['relationship']);

    if ($name && $phone && $relationship) {
        $stmt = $conn->prepare("UPDATE beneficiaries SET name=?, phone=?, relationship=? WHERE id=? AND user_id=?");
        $stmt->bind_param("sssii", $name, $phone, $relationship, $bid, $user_id);
        $stmt->execute();
        $stmt->close();
        $success = "Beneficiary updated successfully.";
    } else {
        $error = "All fields are required.";
    }
}

/* ==========================
   FETCH BENEFICIARIES
========================== */
$stmt = $conn->prepare("SELECT id, name, phone, relationship FROM beneficiaries WHERE user_id=? ORDER BY id DESC");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$beneficiaries = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beneficiaries - EdwumaSupa</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
<style>
body {
    margin: 0;
    font-family: 'Poppins', sans-serif;
    background: #F9F9F9;
    color: #000;
}

/* Header */
header {
    background: linear-gradient(135deg, #F58220 0%, #D85C00 100%);
    padding: 15px 20px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    color: #fff;
    position: fixed;
    width: 100%;
    top: 0;
    z-index: 1001;
}
.hamburger { font-size: 22px; cursor: pointer; }
.header-right { display: flex; align-items: center; gap: 10px; }
.user-name { white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
.logout-link { color: #fff; font-size: 18px; }
.container { padding: 100px 20px; }

/* Cards and lists */
.beneficiary-item {
    background: #fff;
    padding: 15px;
    margin-bottom: 12px;
    border-radius: 12px;
    box-shadow: 0 3px 10px rgba(0,0,0,0.06);
    display: flex;
    justify-content: space-between;
    align-items: center;
}
.btn-sm {
    padding: 6px 10px;
    border-radius: 8px;
    font-size: 13px;
    cursor: pointer;
    border: none;
}
.edit-btn { background:#007bff; color:#fff; }
.delete-btn { background:#dc3545; color:#fff; }

/* Form styling */
.form-card {
    background:#fff;
    padding:20px;
    border-radius:16px;
    box-shadow:0 4px 18px rgba(0,0,0,0.09);
    margin-bottom:25px;
}
input {
    width:90%;
    padding:12px;
    border-radius:10px;
    border:1px solid #ccc;
    margin-bottom:12px;
}
button[type="submit"] {
    width:100%;
    padding:14px;
    background:#F58220;
    color:#fff;
    border:none;
    border-radius:12px;
    font-size:16px;
}
.success { background:#d4edda;color:#155724;padding:12px;border-radius:10px;margin-bottom:15px; }
.error { background:#f8d7da;color:#721c24;padding:12px;border-radius:10px;margin-bottom:15px; }

.beneficiary-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.beneficiary-list li {
    background: #fff;
    margin-bottom: 8px;
    padding: 12px 15px;
    border-radius: 10px;
    box-shadow: 0 3px 12px rgba(0,0,0,0.05);
    display: flex;
    justify-content: space-between;
    align-items: center;
    font-size: 13px;  /* Reduced size */
}

.beneficiary-list li span {
    display: block;
    line-height: 1.2;
}

.beneficiary-list li span:first-child {
    font-weight: 600;
    color: #333;
}

.beneficiary-list li span:last-child {
    font-weight: 500;
    color: #666;
    font-size: 12px; /* Slightly smaller for phone */
}

</style>

</head>
<body>

<header>
    <div class="back" onclick="window.location='dashboard.php'"><i class="fa-solid fa-arrow-left"></i></div>
    <div class="header-right">
        <span class="user-name"><i class="fa-solid fa-user"></i>  <?=htmlspecialchars($user['full_name'] ?? 'User')?>
</span>
        <a href="logout.php" class="logout-link"><i class="fa-solid fa-right-from-bracket"></i></a>
    </div>
</header>

<div class="container">

<?php if ($success): ?>
<div class="success"><?= $success ?></div>
<?php endif; ?>

<?php if ($error): ?>
<div class="error"><?= $error ?></div>
<?php endif; ?>


<!-- ADD BENEFICIARY -->
<div class="form-card">
    <h3><font color='#F58220'>Add Beneficiary</font></h3>
    <form method="POST">
        <input type="text" name="name" placeholder="Full Name" required>
        <input type="text" name="phone" placeholder="Phone Number" required>
        <input type="text" name="relationship" placeholder="Relationship (e.g. Wife, Son)" required>
        <button type="submit" name="add">Add Beneficiary</button>
    </form>
</div>


<!-- BENEFICIARY LIST -->
<h3><font color='#F58220'>My Beneficiaries</font></h3>

<?php if (empty($beneficiaries)): ?>
    <p>No beneficiaries added yet.</p>
<?php endif; ?>

<?php foreach ($beneficiaries as $b): ?>
<div class="beneficiary-item">
    <div>
        <strong><?= htmlspecialchars($b['name']) ?></strong><br>
        <small><?= htmlspecialchars($b['relationship']) ?></small><br>
        <small><?= htmlspecialchars($b['phone']) ?></small>
    </div>

    <div>
        <!-- EDIT BUTTON -->
        <button class="btn-sm edit-btn" onclick="openEditModal(
            <?= $b['id'] ?>,
            '<?= htmlspecialchars($b['name'], ENT_QUOTES) ?>',
            '<?= htmlspecialchars($b['phone'], ENT_QUOTES) ?>',
            '<?= htmlspecialchars($b['relationship'], ENT_QUOTES) ?>'
        )">Edit</button>

        <!-- DELETE BUTTON -->
        <a href="?delete=<?= $b['id'] ?>" onclick="return confirm('Delete this beneficiary?')">
            <button class="btn-sm delete-btn">Delete</button>
        </a>
    </div>
</div>
<?php endforeach; ?>


<!-- EDIT MODAL -->
<div id="editModal" style="
    display:none;position:fixed;top:0;left:0;width:100%;height:100%;
    background:rgba(0,0,0,0.4);padding-top:80px;
">
    <div style="
        background:#fff;margin:auto;padding:20px;border-radius:14px;
        max-width:350px;
    ">
        <h3><font color='#F58220'>Edit Beneficiary</font></h3>
        <form method="POST">
            <input type="hidden" name="bid" id="edit_id">
            <input type="text" name="name" id="edit_name" required>
            <input type="text" name="phone" id="edit_phone" required>
            <input type="text" name="relationship" id="edit_relationship" required>
            <button type="submit" name="update">Update</button>
            <button type="button" onclick="closeEditModal()" style="margin-top:10px;background:#ccc;">Cancel</button>
        </form>
    </div>
</div>

<script>
function openEditModal(id, name, phone, relationship) {
    document.getElementById('edit_id').value = id;
    document.getElementById('edit_name').value = name;
    document.getElementById('edit_phone').value = phone;
    document.getElementById('edit_relationship').value = relationship;
    document.getElementById('editModal').style.display = 'block';
}

function closeEditModal() {
    document.getElementById('editModal').style.display = 'none';
}
</script>

</div>

<footer>
    &copy; <?=date('Y')?> 3y3 Supa. Powered by Tekpulse Consult Ltd.
</footer>

<style>
footer {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background: #f5f5f5; /* light grey / whitish */
    color: #333; /* dark text for contrast */
    text-align: center;
    padding: 12px 0;
    font-size: 14px;
    box-shadow: 0 -3px 10px rgba(0,0,0,0.1);
}

footer a {
    color: #002147; /* optional: make any links dark blue */
    text-decoration: none;
}

@media (max-width: 400px) {
    footer {
        font-size: 12px;
        padding: 10px 0;
    }
}
</style>


</body>
</html>
