<?php
session_start();
include('../config.php');

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input_phone = preg_replace('/\D/', '', $_POST['phone'] ?? '');
    $pin = $_POST['pin'] ?? '';

    if (!$input_phone || !$pin) {
        $error = "Enter both phone number and PIN";
    } else {
        // Normalize phone number: convert 0XXXX... to 233XXXX...
        if (strlen($input_phone) == 10 && substr($input_phone, 0, 1) == '0') {
            $normalized_phone = '233' . substr($input_phone, 1);
        } else {
            $normalized_phone = $input_phone;
        }

        // Fetch user using normalized phone
        $stmt = $conn->prepare("SELECT id, full_name, phone, pin FROM users WHERE phone=? LIMIT 1");
        $stmt->bind_param("s", $normalized_phone);
        $stmt->execute();
        $user = $stmt->get_result()->fetch_assoc();
        $stmt->close();

        if ($user && password_verify($pin, $user['pin'])) {
            $_SESSION['user_id'] = $user['id'];
            header("Location: dashboard.php");
            exit;
        } else {
            $error = "Invalid phone number or PIN";
        }
    }
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>EdwumaSupa - Login</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
<style>
body {
    margin:0; font-family:'Poppins',sans-serif; background:#F9F9F9;
}
header {
    background: linear-gradient(135deg,#F58220 0%,#D85C00 100%);
    color:#fff; padding:15px 20px; text-align:center; font-size:1.5rem;
}
.container {
    padding:20px; max-width:400px; margin:80px auto 20px auto;
}
.card {
    background:#fff; border-radius:12px; padding:20px; margin-bottom:15px; text-align:center;
    box-shadow:0 6px 20px rgba(0,0,0,0.1);
}
.card h2 { color:#D85C00; margin-bottom:15px; }
.card input, .card button {
    width:100%; padding:12px 15px; margin-bottom:12px; border-radius:8px; border:1px solid #ccc; font-size:16px; box-sizing:border-box;
}
.card button {
    background:#F58220; color:#fff; border:none; cursor:pointer; transition:0.3s;
}
.card button:hover { background:#D85C00; }
.error { color:red; margin-bottom:15px; text-align:center; font-size:14px; }
p { text-align:center; margin-top:10px; }
a { color:#F58220; text-decoration:none; }
a:hover { text-decoration:underline; }
@media(max-width:400px){
    .container { margin:80px 10px 20px 10px; }
    .card input, .card button { font-size:14px; padding:10px 12px; }
}
</style>
</head>
<body>

<header><a href='../index.php'><font color='white'>3y3 Supa</font></a></header>

<div class="container">

    <div class="card">
        <h2>Login to 3y3 Supa</h2>

        <?php if($error): ?>
            <div class="error"><?=htmlspecialchars($error)?></div>
        <?php endif; ?>

        <form method="post" action="">
            <input type="tel" name="phone" placeholder="Phone Number" required value="<?=htmlspecialchars($_POST['phone'] ?? '')?>">
            <input type="password" name="pin" placeholder="PIN" required>
            <button type="submit"><i class="fa-solid fa-right-to-bracket"></i> Login</button>
        </form>

        <p>
            Don't have an account? <a href="register.php">Register here</a>
        </p>
    </div>

</div>

<footer>
    &copy; <?=date('Y')?> 3y3 Supa. Powered by Tekpulse Consult Ltd.
</footer>

<style>
footer {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background: #f5f5f5; /* light grey / whitish */
    color: #333; /* dark text for contrast */
    text-align: center;
    padding: 12px 0;
    font-size: 14px;
    box-shadow: 0 -3px 10px rgba(0,0,0,0.1);
}

footer a {
    color: #002147; /* optional: make any links dark blue */
    text-decoration: none;
}

@media (max-width: 400px) {
    footer {
        font-size: 12px;
        padding: 10px 0;
    }
}
</style>

</body>
</html>
