<?php
// index.php
session_start();

// Device detection function
function isMobile() {
    $userAgent = strtolower($_SERVER['HTTP_USER_AGENT']);
    $mobileAgents = ['iphone', 'ipad', 'android', 'blackberry', 'mobile', 'opera mini', 'windows phone'];
    foreach ($mobileAgents as $agent) {
        if (strpos($userAgent, $agent) !== false) return true;
    }
    return false;
}

// Redirect if user is already logged in
if (isset($_SESSION['user_id'])) {
    if (isMobile()) {
        header("Location: mobile/index.php");
    } else {
        header("Location: web/index.php");
    }
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>EdwumaSupa - 3y3 Supa Superannuation</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
<style>
body {
    margin:0;
    font-family: 'Poppins', sans-serif;
    background: linear-gradient(135deg, #F58220 0%, #D85C00 100%);
    color: #fff;
}
.hero {
    display:flex;
    flex-direction:column;
    justify-content:center;
    align-items:center;
    text-align:center;
    min-height:100vh;
    padding:20px;
}
.hero h1 {
    font-size:2.5rem;
    margin-bottom:20px;
}
.hero p {
    font-size:1.2rem;
    max-width:600px;
    margin-bottom:30px;
}
.hero .btn {
    background:#fff;
    color:#D85C00;
    font-weight:600;
    padding:15px 30px;
    border-radius:12px;
    text-decoration:none;
    font-size:1.1rem;
    transition:0.3s;
}
.hero .btn:hover {
    background:#F58220;
    color:#fff;
}
.features {
    display:grid;
    grid-template-columns: repeat(auto-fit, minmax(250px,1fr));
    gap:20px;
    padding:50px 20px;
    background:#fff;
    color:#333;
}
.feature-card {
    background:#F9F9F9;
    padding:25px;
    border-radius:12px;
    box-shadow:0 6px 20px rgba(0,0,0,0.1);
    text-align:center;
    transition:0.3s;
}
.feature-card:hover { transform: translateY(-5px); box-shadow:0 12px 30px rgba(0,0,0,0.15); }
.feature-card i { font-size:40px; color:#D85C00; margin-bottom:15px; }
.feature-card h3 { margin-bottom:10px; }
</style>
</head>
<body>

<section class="hero">
    <h1>Welcome to <span style="color:#FFD700;">3y3 Supa</span></h1>
    <p>The innovative superannuation scheme designed for Ghana’s informal sector and gig economy. Secure your future, contribute flexibly, and track your pension easily.</p>
    <a href="<?php echo isMobile() ? 'mobile/register.php' : 'web/register.php'; ?>" class="btn">Get Started</a>
</section>

<section class="features">
    <div class="feature-card">
        <i class="fa-solid fa-people-group"></i>
        <h3>For the Informal Sector</h3>
        <p>Designed for market traders, artisans, and freelance workers to contribute easily without formal payroll deductions.</p>
    </div>
    <div class="feature-card">
        <i class="fa-solid fa-briefcase"></i>
        <h3>Gig Economy Friendly</h3>
        <p>Whether you’re a driver, delivery agent, or online freelancer, manage your contributions on the go using mobile or web.</p>
    </div>
    <div class="feature-card">
        <i class="fa-solid fa-lock"></i>
        <h3>Secure & Transparent</h3>
        <p>Monitor your balance and contributions securely. Your pension is tracked monthly and updated in real-time.</p>
    </div>
</section>

</body>
</html>
