<?php
session_start();
include('../config.php');

if (!isset($_SESSION['agent_id'])) {
    die("Unauthorized access");
}

if ($_SERVER['REQUEST_METHOD'] !== "POST") {
    die("Invalid request");
}

$id = intval($_POST['id']);

$sql = "
UPDATE users SET
    alt_phone = ?,
    dob = ?,
    gender = ?,
    ghana_card = ?,
    ssnit_number = ?,
    region = ?,
    district = ?,
    community = ?,
    gps_address = ?,
    occupation = ?,
    work_category = ?,
    employer = ?,
    work_location = ?,
    preferred_amount = ?,
    contribution_frequency = ?,
    emergency_name = ?,
    emergency_phone = ?,
    emergency_relation = ?,
    registration_channel = 'CALL_CENTER',
    assignment_status = 'completed'
WHERE id = ?
";

$stmt = $conn->prepare($sql);
$stmt->bind_param(
    "sssssssssssssdsssssi",
    $_POST['alt_phone'],
    $_POST['dob'],
    $_POST['gender'],
    $_POST['ghana_card'],
    $_POST['ssnit_number'],
    $_POST['region'],
    $_POST['district'],
    $_POST['community'],
    $_POST['gps_address'],
    $_POST['occupation'],
    $_POST['work_category'],
    $_POST['employer'],
    $_POST['work_location'],
    $_POST['preferred_amount'],
    $_POST['contribution_frequency'],
    $_POST['emergency_name'],
    $_POST['emergency_phone'],
    $_POST['emergency_relation'],
    $id
);

if ($stmt->execute()) {
    header("Location: callcenter_dashboard.php?success=1");
} else {
    echo "Error: " . $conn->error;
}






