<?php
session_start();
include('../config.php');

if (!isset($_SESSION['agent_id'])) {
    die("Unauthorized");
}

$agent_id = $_SESSION['agent_id'];
$user_id = intval($_GET['id']);

// LOCK THE USER (only if still unassigned)
$sql = "
    UPDATE users 
    SET assigned_agent_id = ?, assignment_status = 'assigned'
    WHERE id = ? AND assignment_status = 'unassigned'
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $agent_id, $user_id);
$stmt->execute();

// Redirect to edit page
header("Location: callcenter_edit_user.php?id=" . $user_id);
exit;
