<?php
session_start();
include('../config.php');

if (!isset($_SESSION['agent_id'])) {
    header("Location: login.php");
    exit;
}

$page = 'reports'; // for sidebar active state
$agent_id = $_SESSION['agent_id'];

// Fetch stats
$totalAssigned = $conn->query("SELECT COUNT(*) AS total FROM users WHERE assigned_agent_id = $agent_id")->fetch_assoc()['total'];
$totalCompleted = $conn->query("SELECT COUNT(*) AS total FROM users WHERE assigned_agent_id = $agent_id AND assignment_status = 'completed'")->fetch_assoc()['total'];
$totalPending = $conn->query("SELECT COUNT(*) AS total FROM users WHERE assigned_agent_id = $agent_id AND assignment_status = 'assigned'")->fetch_assoc()['total'];

// Fetch assigned users
$assignedUsers = $conn->query("
    SELECT * FROM users
    WHERE assigned_agent_id = $agent_id
    ORDER BY id DESC
");
?>

<?php include 'layout.php'; ?>

<div class="content" style="padding:15px;">
    <h2 style="font-size:18px; color:#002147; margin-bottom:10px;">Reports Dashboard</h2>

    <!-- KPI Cards -->
    <div style="display:flex; flex-wrap:wrap; gap:8px; margin-bottom:15px;">
        <div class="card" style="flex:1; min-width:120px; background:#0072CE; color:#fff; padding:8px; text-align:left;">
            <h3 style="font-size:12px; margin:0 0 4px;">Total Assigned</h3>
            <p style="font-size:16px; font-weight:bold; margin:0;"><?= $totalAssigned ?></p>
        </div>
        <div class="card" style="flex:1; min-width:120px; background:#28a745; color:#fff; padding:8px; text-align:left;">
            <h3 style="font-size:12px; margin:0 0 4px;">Completed</h3>
            <p style="font-size:16px; font-weight:bold; margin:0;"><?= $totalCompleted ?></p>
        </div>
        <div class="card" style="flex:1; min-width:120px; background:#FFC107; color:#002147; padding:8px; text-align:left;">
            <h3 style="font-size:12px; margin:0 0 4px;">Pending</h3>
            <p style="font-size:16px; font-weight:bold; margin:0;"><?= $totalPending ?></p>
        </div>
    </div>

    <!-- Assigned Users Table -->
    <div class="card" style="padding:8px;">
        <h3 style="font-size:14px; margin-bottom:6px;">Assigned Users</h3>

        <?php if ($assignedUsers->num_rows == 0): ?>
            <p style="font-size:12px; color:#555; margin:0;">No assigned users yet.</p>
        <?php else: ?>
            <table style="width:100%; border-collapse:collapse; font-size:12px; text-align:left;">
                <thead>
                    <tr style="background:#0072CE;color:#fff;">
                        <th style="padding:4px; text-align:left;">ID</th>
                        <th style="padding:4px; text-align:left;">Name</th>
                        <th style="padding:4px; text-align:left;">Phone</th>
                        <th style="padding:4px; text-align:left;">Region</th>
                        <th style="padding:4px; text-align:left;">District</th>
                        <th style="padding:4px; text-align:left;">Status</th>
                        <th style="padding:4px; text-align:left;">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($u = $assignedUsers->fetch_assoc()): ?>
                        <tr style="border-bottom:1px solid #ddd;">
                            <td style="padding:3px;"><?= $u['id'] ?></td>
                            <td style="padding:3px;"><?= htmlspecialchars($u['full_name'] ?? '') ?></td>
                            <td style="padding:3px;"><?= htmlspecialchars($u['phone'] ?? '') ?></td>
                            <td style="padding:3px;"><?= htmlspecialchars($u['region'] ?? '') ?></td>
                            <td style="padding:3px;"><?= htmlspecialchars($u['district'] ?? '') ?></td>
                            <td style="padding:3px;">
                                <?php
                                    $statusColor = '#FFC107';
                                    if ($u['assignment_status']=='completed') $statusColor = '#28a745';
                                    else if ($u['assignment_status']=='assigned') $statusColor = '#0072CE';
                                ?>
                                <span style="background:<?= $statusColor ?>; color:#fff; padding:2px 5px; border-radius:4px; font-size:11px;">
                                    <?= $u['assignment_status'] ?? 'N/A' ?>
                                </span>
                            </td>
                            <td style="padding:3px;">
                                <a href="callcenter_edit_user.php?id=<?= $u['id'] ?>" 
                                   style="background:#FFB400;color:#002147;padding:3px 6px;border-radius:4px;text-decoration:none; font-size:11px;">
                                   Edit
                                </a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div> <!-- end content -->

<?php include 'layout_end.php'; ?>
