<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
include('../config.php');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("Location: login.php?error=Invalid request");
    exit;
}

$email = $_POST['email'];
$password = $_POST['password'];

$query = $conn->prepare("SELECT * FROM call_center_agents WHERE email = ? AND status = 'active'");
$query->bind_param("s", $email);
$query->execute();
$result = $query->get_result();

if ($result->num_rows === 0) {
    header("Location: login.php?error=Invalid email or inactive account");
    exit;
}

$agent = $result->fetch_assoc();

// Check password
if (!password_verify($password, $agent['password'])) {
    header("Location: login.php?error=Incorrect password");
    exit;
}

// Login success
$_SESSION['agent_id'] = $agent['id'];
$_SESSION['agent_name'] = $agent['full_name'];

header("Location: callcenter_dashboard.php");
exit;
