<?php
session_start();
require_once '../config.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);

    $stmt = $conn->prepare("SELECT * FROM call_center_agents WHERE email = ? LIMIT 1");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $agent = $result->fetch_assoc();

        if ($agent['status'] !== 'active') {
            $error = "Your account is inactive.";
        } elseif (password_verify($password, $agent['password'])) {
            $_SESSION['agent_id'] = $agent['id'];
            $_SESSION['agent_name'] = $agent['full_name'];
            $_SESSION['agent_email'] = $agent['email'];

            header("Location: callcenter_dashboard.php");
            exit;
        } else {
            $error = "Incorrect password.";
        }
    } else {
        $error = "Account not found.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Call Center Admin Login</title>

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
        font-family: 'Poppins', sans-serif;
    }

    body {
        height: 100vh;
        background: linear-gradient(140deg, #002147, #0072CE);
        display: flex;
        justify-content: center;
        align-items: center;
        padding: 20px;
    }

    .container {
        background: #ffffff;
        padding: 40px;
        width: 380px;
        border-radius: 15px;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.25);
        animation: fadeIn 0.7s ease-out;
        border-top: 8px solid #FFB400;
    }

    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .title {
        text-align: center;
        font-size: 26px;
        font-weight: 700;
        color: #002147;
    }

    .subtitle {
        text-align: center;
        font-size: 14px;
        color: #555;
        margin-bottom: 25px;
    }

    .input-group {
        margin-bottom: 20px;
    }

    label {
        display: block;
        margin-bottom: 4px;
        font-weight: 500;
        color: #002147;
    }

    input {
        width: 100%;
        padding: 12px;
        border-radius: 8px;
        border: 1px solid #c7c7c7;
        font-size: 15px;
        background: #f8f8f8;
        outline: none;
    }

    input:focus {
        border-color: #0072CE;
    }

    button {
        width: 100%;
        padding: 14px;
        background: #FFB400;
        color: #002147;
        font-size: 16px;
        border: none;
        font-weight: 600;
        border-radius: 8px;
        cursor: pointer;
        transition: 0.3s ease;
        margin-top: 10px;
    }

    button:hover {
        background: #e2a200;
    }

    .error {
        background: rgba(255, 0, 0, 0.18);
        color: #b30000;
        padding: 10px;
        border-radius: 8px;
        margin-bottom: 15px;
        text-align: center;
    }

    .footer {
        text-align: center;
        margin-top: 20px;
        font-size: 12px;
        color: #eee;
    }
</style>

</head>
<body>

<div class="container">
    <div class="title">EdwumaSupa</div>
    <div class="subtitle">Call Center Admin Login Portal</div>

    <?php if ($error): ?>
        <div class="error"><?= $error ?></div>
    <?php endif; ?>

    <form action="" method="POST">

        <div class="input-group">
            <label>Email Address</label>
            <input type="email" name="email" placeholder="Enter email" required>
        </div>

        <div class="input-group">
            <label>Password</label>
            <input type="password" name="password" placeholder="Enter password" required>
        </div>

        <button type="submit">Login</button>
    </form>
</div>

</body>
</html>
