<?php
if (!isset($_SESSION['agent_id'])) {
    header("Location: login.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Call Center Portal</title>

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<style>
    body {
        margin: 0;
        font-family: 'Poppins', sans-serif;
        background: #f4f6f9;
        display: flex;
    }

    /* SIDEBAR */
    .sidebar {
        width: 250px;
        height: 100vh;
        background: #002147;
        color: white;
        position: fixed;
        left: 0;
        top: 0;
        display: flex;
        flex-direction: column;
        padding: 20px 0;
        overflow-y: auto;
        transition: all 0.3s ease;
    }

    .sidebar h2 {
        text-align: center;
        font-size: 22px;
        color: #FFB400;
        margin-bottom: 20px;
        font-weight: 700;
    }

    .sidebar a {
        padding: 14px 25px;
        color: #ffffff;
        text-decoration: none;
        font-size: 15px;
        display: flex;
        align-items: center;
        gap: 12px;
        border-left: 4px solid transparent;
        transition: 0.25s;
    }

    .sidebar a:hover {
        background: #0072CE;
        border-left: 4px solid #FFB400;
    }

    .sidebar a.active {
        background: #003366;
        border-left: 4px solid #FFB400;
        font-weight: 600;
    }

    /* MAIN CONTENT */
    .main {
        margin-left: 250px;
        width: calc(100% - 250px);
        transition: all 0.3s;
    }

    .header {
        background: #fff;
        padding: 15px 25px;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .header span {
        font-size: 16px;
        font-weight: 500;
        color: #002147;
    }

    .logout-btn {
        background: #FFB400;
        color: #002147;
        padding: 8px 14px;
        border-radius: 6px;
        text-decoration: none;
        font-weight: 600;
    }

    .logout-btn:hover {
        background: #e2a200;
    }

    .content {
        padding: 30px;
    }

    .card {
        background: #fff;
        padding: 25px;
        border-radius: 12px;
        box-shadow: 0 3px 12px rgba(0,0,0,0.08);
        margin-bottom: 25px;
    }

    .card h3 {
        margin-bottom: 20px;
    }
</style>
</head>
<body>

<!-- Sidebar -->
<div class="sidebar">
    <h2>EdwumaSupa</h2>
    <a href="callcenter_dashboard.php" class="<?= ($page=='dashboard')?'active':'' ?>">📊 Dashboard</a>
    <a href="assigned_users.php" class="<?= ($page=='assigned_users')?'active':'' ?>">👥 Assigned Users</a>
    <a href="get_user.php" class="<?= ($page=='get_user')?'active':'' ?>">🔍 Search User</a>
    <a href="update_user.php" class="<?= ($page=='update_user')?'active':'' ?>">✏️ Update User</a>
    <a href="call_session.php" class="<?= ($page=='call_session')?'active':'' ?>">📞 Call Session</a>
    <a href="reports.php" class="<?= ($page=='reports')?'active':'' ?>">📄 Reports</a>
    <a href="logout.php">🚪 Logout</a>
</div>

<!-- Main -->
<div class="main">
    <!-- Header -->
    <div class="header">
        <span>Welcome, <?= $_SESSION['agent_name'] ?></span>
        <a href="logout.php" class="logout-btn">Logout</a>
    </div>

    <!-- Page Content -->
    <div class="content">
