<?php
session_start();
include('../config.php');

if (!isset($_SESSION['agent_id'])) {
    header("Location: login.php");
    exit;
}

$page = 'get_user'; // for sidebar active state

$search = '';
$results = [];

if (isset($_GET['search'])) {
    $search = $conn->real_escape_string(trim($_GET['search']));
    
    $query = "
        SELECT * FROM users 
        WHERE full_name LIKE '%$search%'
           OR phone LIKE '%$search%'
           OR ghana_card LIKE '%$search%'
           OR ssnit_number LIKE '%$search%'
        ORDER BY id DESC
        LIMIT 50
    ";
    
    $res = $conn->query($query);
    if ($res) {
        while ($row = $res->fetch_assoc()) {
            $results[] = $row;
        }
    }
}
?>

<?php include 'layout.php'; ?>

<div class="content" style="padding:15px;">
    <h2 style="font-size:20px; color:#002147; margin-bottom:10px;">Search Users</h2>

    <div class="card" style="padding:10px; margin-bottom:15px;">
        <form method="GET" style="display:flex; gap:8px; flex-wrap:wrap; align-items:center;">
            <input type="text" name="search" placeholder="Enter name, phone, Ghana Card, or SSNIT #" 
                   value="<?= htmlspecialchars($search ?? '') ?>" 
                   style="flex:1; padding:6px; font-size:13px; border-radius:4px; border:1px solid #ccc;">
            <button type="submit" style="background:#FFB400;color:#002147;padding:6px 12px; border:none; border-radius:6px; font-weight:bold; font-size:13px;">
                Search
            </button>
        </form>
    </div>

    <?php if (isset($_GET['search'])): ?>
        <div class="card" style="padding:10px; margin-top:10px;">
            <?php if (count($results) == 0): ?>
                <p style="font-size:13px; color:#555;">No users found for <b><?= htmlspecialchars($search) ?></b>.</p>
            <?php else: ?>
                <table style="width:100%; border-collapse:collapse; font-size:13px; text-align:left;">
                    <thead>
                        <tr style="background:#0072CE;color:#fff;">
                            <th style="padding:6px; text-align:left;">ID</th>
                            <th style="padding:6px; text-align:left;">Name</th>
                            <th style="padding:6px; text-align:left;">Phone</th>
                            <th style="padding:6px; text-align:left;">Region</th>
                            <th style="padding:6px; text-align:left;">District</th>
                            <th style="padding:6px; text-align:left;">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($results as $u): ?>
                            <tr style="border-bottom:1px solid #ddd;">
                                <td style="padding:4px; text-align:left;"><?= $u['id'] ?></td>
                                <td style="padding:4px; text-align:left;"><?= htmlspecialchars($u['full_name'] ?? '') ?></td>
                                <td style="padding:4px; text-align:left;"><?= htmlspecialchars($u['phone'] ?? '') ?></td>
                                <td style="padding:4px; text-align:left;"><?= htmlspecialchars($u['region'] ?? '') ?></td>
                                <td style="padding:4px; text-align:left;"><?= htmlspecialchars($u['district'] ?? '') ?></td>
                                <td style="padding:4px; text-align:left;">
                                    <a href="callcenter_edit_user.php?id=<?= $u['id'] ?>" 
                                       style="background:#FFB400;color:#002147;padding:4px 8px;border-radius:4px;text-decoration:none; font-size:12px;">
                                       Edit
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div> <!-- end content -->

<?php include 'layout_end.php'; ?>
