<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
include('../config.php');

if (!isset($_SESSION['agent_id'])) {
    header("Location: login.php");
    exit;
}

$agent_id = $_SESSION['agent_id'];
$page = 'update_user'; // for sidebar active state

if (!isset($_GET['id'])) {
    header("Location: callcenter_dashboard.php");
    exit;
}

$user_id = intval($_GET['id']);

// Fetch user info
$userQuery = $conn->query("SELECT * FROM users WHERE id = $user_id");
if ($userQuery->num_rows == 0) {
    echo "User not found";
    exit;
}
$user = $userQuery->fetch_assoc();

// Handle form submission
$success = $error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = $conn->real_escape_string($_POST['full_name']);
    $phone = $conn->real_escape_string($_POST['phone']);
    $dob = $_POST['dob'];
    $gender = $_POST['gender'];
    $ghana_card = $conn->real_escape_string($_POST['ghana_card']);
    $ssnit_number = $conn->real_escape_string($_POST['ssnit_number']);
    $region = $_POST['region'];
    $district = $_POST['district'];
    $community = $conn->real_escape_string($_POST['community']);
    $gps_address = $conn->real_escape_string($_POST['gps_address']);
    $occupation = $conn->real_escape_string($_POST['occupation']);
    $work_category = $_POST['work_category'];
    $employer = $conn->real_escape_string($_POST['employer']);
    $work_location = $conn->real_escape_string($_POST['work_location']);
    $preferred_amount = floatval($_POST['preferred_amount']);
    $contribution_frequency = $_POST['contribution_frequency'];
    $emergency_name = $conn->real_escape_string($_POST['emergency_name']);
    $emergency_phone = $conn->real_escape_string($_POST['emergency_phone']);
    $emergency_relation = $conn->real_escape_string($_POST['emergency_relation']);
    $sector = $_POST['sector'];

    $updateQuery = "
        UPDATE users SET 
        full_name='$full_name',
        phone='$phone',
        dob='$dob',
        gender='$gender',
        ghana_card='$ghana_card',
        ssnit_number='$ssnit_number',
        region='$region',
        district='$district',
        community='$community',
        gps_address='$gps_address',
        occupation='$occupation',
        work_category='$work_category',
        employer='$employer',
        work_location='$work_location',
        preferred_amount='$preferred_amount',
        contribution_frequency='$contribution_frequency',
        emergency_name='$emergency_name',
        emergency_phone='$emergency_phone',
        emergency_relation='$emergency_relation',
        sector='$sector'
        WHERE id=$user_id
    ";

    if ($conn->query($updateQuery)) {
        $success = "User updated successfully!";
        $user = $conn->query("SELECT * FROM users WHERE id = $user_id")->fetch_assoc();
    } else {
        $error = "Update failed: " . $conn->error;
    }
}
?>

<?php include 'layout.php'; ?>

<div class="content">
    <h2>Edit User: <?= htmlspecialchars($user['full_name']) ?></h2>

    <?php if ($success): ?>
        <div class="card" style="background:#d4edda;color:#155724; border-left:4px solid #28a745;">
            <?= $success ?>
        </div>
    <?php endif; ?>
    <?php if ($error): ?>
        <div class="card" style="background:#f8d7da;color:#721c24; border-left:4px solid #dc3545;">
            <?= $error ?>
        </div>
    <?php endif; ?>

    <div class="card">
        <form method="POST">
            <div style="display:flex;flex-wrap:wrap;gap:20px;">

                <div style="flex:1; min-width:250px;">
                    <label>Full Name</label>
                    <input type="text" name="full_name" value="<?= htmlspecialchars($user['full_name']) ?>" required>
                </div>

                <div style="flex:1; min-width:250px;">
                    <label>Phone</label>
                    <input type="text" name="phone" value="<?= htmlspecialchars($user['phone']) ?>" required>
                </div>

                <div style="flex:1; min-width:250px;">
                    <label>Date of Birth</label>
                    <input type="date" name="dob" value="<?= $user['dob'] ?>">
                </div>

                <div style="flex:1; min-width:250px;">
                    <label>Gender</label>
                    <select name="gender">
                        <option value="">Select</option>
                        <option value="male" <?= ($user['gender']=='male')?'selected':'' ?>>Male</option>
                        <option value="female" <?= ($user['gender']=='female')?'selected':'' ?>>Female</option>
                        <option value="other" <?= ($user['gender']=='other')?'selected':'' ?>>Other</option>
                    </select>
                </div>

                <div style="flex:1; min-width:250px;">
                    <label>Ghana Card</label>
                    <input type="text" name="ghana_card" value="<?= htmlspecialchars($user['ghana_card'] ?? '') ?>">
                </div>

                <div style="flex:1; min-width:250px;">
                    <label>SSNIT Number</label>
                    <input type="text" name="ssnit_number" value="<?= htmlspecialchars($user['ssnit_number'] ?? '') ?>">
                </div>

                <div style="flex:1; min-width:250px;">
                    <label>Region</label>
                    <input type="text" name="region" value="<?= htmlspecialchars($user['region'] ?? '') ?>">
                </div>

                <div style="flex:1; min-width:250px;">
                    <label>District</label>
                    <input type="text" name="district" value="<?= htmlspecialchars($user['district'] ?? '') ?>">
                </div>

                <div style="flex:1; min-width:250px;">
                    <label>Community</label>
                    <input type="text" name="community" value="<?= htmlspecialchars($user['community'] ?? '') ?>">
                </div>

                <div style="flex:1; min-width:250px;">
                    <label>GPS Address</label>
                    <input type="text" name="gps_address" value="<?= htmlspecialchars($user['gps_address'] ?? '') ?>">
                </div>

                <div style="flex:1; min-width:250px;">
                    <label>Occupation</label>
                    <input type="text" name="occupation" value="<?= htmlspecialchars($user['occupation'] ?? '') ?>">
                </div>

                <div style="flex:1; min-width:250px;">
                    <label>Work Category</label>
                    <input type="text" name="work_category" value="<?= htmlspecialchars($user['work_category'] ?? '') ?>">
                </div>

                <div style="flex:1; min-width:250px;">
                    <label>Employer</label>
                    <input type="text" name="employer" value="<?= htmlspecialchars($user['employer'] ?? '') ?>">
                </div>

                <div style="flex:1; min-width:250px;">
                    <label>Work Location</label>
                    <input type="text" name="work_location" value="<?= htmlspecialchars($user['work_location'] ?? '') ?>">
                </div>

                <div style="flex:1; min-width:250px;">
                    <label>Preferred Amount</label>
                    <input type="number" step="0.01" name="preferred_amount" value="<?= $user['preferred_amount'] ?>">
                </div>

                <div style="flex:1; min-width:250px;">
                    <label>Contribution Frequency</label>
                    <select name="contribution_frequency">
                        <option value="daily" <?= ($user['contribution_frequency']=='daily')?'selected':'' ?>>Daily</option>
                        <option value="weekly" <?= ($user['contribution_frequency']=='weekly')?'selected':'' ?>>Weekly</option>
                        <option value="monthly" <?= ($user['contribution_frequency']=='monthly')?'selected':'' ?>>Monthly</option>
                        <option value="flexible" <?= ($user['contribution_frequency']=='flexible')?'selected':'' ?>>Flexible</option>
                    </select>
                </div>

                <div style="flex:1; min-width:250px;">
                    <label>Emergency Contact Name</label>
                    <input type="text" name="emergency_name" value="<?= htmlspecialchars($user['emergency_name'] ?? '') ?>">
                </div>

                <div style="flex:1; min-width:250px;">
                    <label>Emergency Phone</label>
                    <input type="text" name="emergency_phone" value="<?= htmlspecialchars($user['emergency_phone'] ?? '') ?>">
                </div>

                <div style="flex:1; min-width:250px;">
                    <label>Emergency Relation</label>
                    <input type="text" name="emergency_relation" value="<?= htmlspecialchars($user['emergency_relation'] ?? '') ?>">
                </div>

                <div style="flex:1; min-width:250px;">
                    <label>Sector</label>
                    <select name="sector">
                        <option value="Informal" <?= ($user['sector']=='Informal')?'selected':'' ?>>Informal</option>
                        <option value="Formal" <?= ($user['sector']=='Formal')?'selected':'' ?>>Formal</option>
                    </select>
                </div>

            </div>

            <button type="submit" style="margin-top:20px;background:#FFB400;color:#002147;padding:10px 20px;border:none;border-radius:8px;font-weight:bold;">Update User</button>
        </form>
    </div>

</div> <!-- end content -->

<?php include 'layout_end.php'; ?>
