<?php
session_start();
include('../config.php');

if (!isset($_SESSION['agent_id'])) {
    header("Location: login.php");
    exit;
}

$agent_id = $_SESSION['agent_id'];
$TASK_LIMIT = 10; // limit per agent

// COUNT how many users already assigned to this agent
$countQuery = $conn->query("SELECT COUNT(*) AS total FROM users WHERE assigned_agent_id = $agent_id AND assignment_status = 'assigned'");
$countRow = $countQuery->fetch_assoc();
$currentCount = $countRow['total'];

// SHOW: users assigned to this agent
$assignedUsers = $conn->query("
    SELECT * FROM users 
    WHERE assigned_agent_id = $agent_id 
    AND assignment_status = 'assigned'
");

// SHOW: unassigned users only if agent has remaining slots
$unassignedUsers = [];
if ($currentCount < $TASK_LIMIT) {
    $unassignedUsers = $conn->query("
        SELECT * FROM users 
        WHERE assignment_status = 'unassigned'
        ORDER BY id ASC
        LIMIT " . ($TASK_LIMIT - $currentCount)
    );
}

$page = 'dashboard'; // for sidebar active state
?>

<?php include 'layout.php'; ?> <!-- your layout.php with sidebar -->

<div class="content" style="padding:15px;">
    <!--<h2 style="color:#002147;">Welcome, <?= $_SESSION['agent_name'] ?></h2>-->
    
    <div class="card" style="display:flex;justify-content:space-between;align-items:center; padding:10px;">
        <div>
            <h3 style="color:#002147; font-size:18px; margin:0;">Your Tasks</h3>
            <p style="font-size:16px; font-weight:bold; margin:2px 0;"><?= $currentCount ?> / <?= $TASK_LIMIT ?></p>
        </div>
        <div style="font-size:32px;color:#FFB400;">📋</div>
    </div>

    <!-- Assigned Users -->
    <div class="card" style="padding:10px;">
        <h3 style="font-size:18px;">Assigned Users</h3>
       <table style="width:100%; border-collapse:collapse; font-size:14px; text-align:left;">
    <thead>
        <tr style="background:#0072CE;color:#fff; font-size:14px;">
            <th style="padding:6px; text-align:left;">ID</th>
            <th style="padding:6px; text-align:left;">Name</th>
            <th style="padding:6px; text-align:left;">Phone</th>
            <th style="padding:6px; text-align:left;">Action</th>
        </tr>
    </thead>
    <tbody>
        <?php while ($u = $assignedUsers->fetch_assoc()): ?>
        <tr style="border-bottom:1px solid #ddd;">
            <td style="padding:4px; text-align:left;"><?= $u['id'] ?></td>
            <td style="padding:4px; text-align:left;"><?= $u['full_name'] ?></td>
            <td style="padding:4px; text-align:left;"><?= $u['phone'] ?></td>
            <td style="padding:4px; text-align:left;">
                <a href="callcenter_edit_user.php?id=<?= $u['id'] ?>" 
                   style="background:#FFB400;color:#002147;padding:4px 8px;border-radius:4px;text-decoration:none;font-size:13px;">Continue</a>
            </td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>

    </div>

    <!-- Unassigned Users -->
    <?php if ($currentCount < $TASK_LIMIT): ?>
    <div class="card" style="padding:10px;">
        <h3 style="font-size:18px;">Available New Users (Unassigned)</h3>
        <table style="width:100%; border-collapse:collapse; font-size:14px; text-align:left;">
    <thead>
        <tr style="background:#0072CE;color:#fff; font-size:14px;">
            <th style="padding:6px; text-align:left;">ID</th>
            <th style="padding:6px; text-align:left;">Name</th>
            <th style="padding:6px; text-align:left;">Phone</th>
            <th style="padding:6px; text-align:left;">Action</th>
        </tr>
    </thead>
    <tbody>
        <?php while ($u = $unassignedUsers->fetch_assoc()): ?>
        <tr style="border-bottom:1px solid #ddd;">
            <td style="padding:4px; text-align:left;"><?= $u['id'] ?></td>
            <td style="padding:4px; text-align:left;"><?= $u['full_name'] ?></td>
            <td style="padding:4px; text-align:left;"><?= $u['phone'] ?></td>
            <td style="padding:4px; text-align:left;">
                <a href="take_user.php?id=<?= $u['id'] ?>" 
                   style="background:#FFB400;color:#002147;padding:4px 8px;border-radius:4px;text-decoration:none;font-size:13px;">Start</a>
            </td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>

    </div>
    <?php else: ?>
        <div class="card" style="padding:10px;">
            <p style="color:#FF0000;font-weight:bold; font-size:14px;">You have reached your task limit. Complete assigned users to unlock more.</p>
        </div>
    <?php endif; ?>

</div> <!-- end content -->

<?php include 'layout_end.php'; ?>
