<?php
session_start();
include('../config.php');

if (!isset($_SESSION['agent_id'])) {
    header("Location: login.php");
    exit;
}

$page = 'call_session'; // for sidebar active state
$agent_id = $_SESSION['agent_id'];

if (!isset($_GET['user_id'])) {
    header("Location: callcenter_dashboard.php");
    exit;
}

$user_id = intval($_GET['user_id']);

// Fetch user
$userQuery = $conn->query("SELECT * FROM users WHERE id=$user_id");
if ($userQuery->num_rows == 0) {
    echo "User not found.";
    exit;
}
$user = $userQuery->fetch_assoc();

// Handle call notes submission
$success = $error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $notes = $conn->real_escape_string($_POST['notes']);
    $status = $_POST['assignment_status']; // assigned / completed

    // Update user assignment status
    $update = $conn->query("UPDATE users SET assignment_status='$status' WHERE id=$user_id");

    // Insert call log
    $log = $conn->query("
        INSERT INTO call_logs (agent_id, user_id, notes, status, date_created) 
        VALUES ($agent_id, $user_id, '$notes', '$status', NOW())
    ");

    if ($update && $log) {
        $success = "Call session saved successfully!";
        $user['assignment_status'] = $status;
    } else {
        $error = "Failed to save call session: " . $conn->error;
    }
}
?>

<?php include 'layout.php'; ?>

<div class="content">
    <h2>Call Session: <?= htmlspecialchars($user['full_name'] ?? '') ?></h2>

    <?php if ($success): ?>
        <div class="card" style="background:#d4edda;color:#155724; border-left:4px solid #28a745;">
            <?= $success ?>
        </div>
    <?php endif; ?>
    <?php if ($error): ?>
        <div class="card" style="background:#f8d7da;color:#721c24; border-left:4px solid #dc3545;">
            <?= $error ?>
        </div>
    <?php endif; ?>

    <div class="card">
        <h3>User Details</h3>
        <p><b>Phone:</b> <?= htmlspecialchars($user['phone'] ?? '') ?></p>
        <p><b>Region:</b> <?= htmlspecialchars($user['region'] ?? '') ?></p>
        <p><b>District:</b> <?= htmlspecialchars($user['district'] ?? '') ?></p>
        <p><b>Assignment Status:</b> 
            <span style="background:<?= ($user['assignment_status']=='completed')?'#28a745':'#0072CE' ?>; color:#fff; padding:4px 8px; border-radius:6px;">
                <?= $user['assignment_status'] ?? 'assigned' ?>
            </span>
        </p>
    </div>

    <div class="card" style="margin-top:20px;">
        <h3>Call Notes</h3>
        <form method="POST">
            <textarea name="notes" rows="5" placeholder="Add notes about this call..." 
                      style="width:100%; padding:10px; border-radius:6px; border:1px solid #ccc;"></textarea>

            <div style="margin-top:10px;">
                <label>Update Assignment Status:</label>
                <select name="assignment_status" style="padding:8px; border-radius:6px; border:1px solid #ccc;">
                    <option value="assigned" <?= ($user['assignment_status']=='assigned')?'selected':'' ?>>Assigned</option>
                    <option value="completed" <?= ($user['assignment_status']=='completed')?'selected':'' ?>>Completed</option>
                </select>
            </div>

            <button type="submit" style="margin-top:15px; background:#FFB400;color:#002147;padding:10px 20px;border:none;border-radius:8px;font-weight:bold;">Save Session</button>
        </form>
    </div>

</div> <!-- end content -->

<?php include 'layout_end.php'; ?>
