<?php
session_start();
include('../config.php');

if (!isset($_SESSION['agent_id'])) {
    header("Location: login.php");
    exit;
}

$agent_id = $_SESSION['agent_id'];
$page = 'assigned_users'; // for sidebar active state

// Fetch assigned users
$assignedUsers = $conn->query("
    SELECT * FROM users
    WHERE assigned_agent_id = $agent_id
    AND assignment_status = 'assigned'
    ORDER BY id DESC
");
?>

<?php include 'layout.php'; ?>

<div class="content" style="padding:15px;">
    <h2 style="font-size:20px; color:#002147; margin-bottom:10px;">Assigned Users</h2>

    <div class="card" style="padding:10px;">
        <?php if ($assignedUsers->num_rows == 0): ?>
            <p style="color:#555; font-size:14px;">No users assigned to you yet.</p>
        <?php else: ?>
            <table style="width:100%; border-collapse:collapse; font-size:13px; text-align:left;">
                <thead>
                    <tr style="background:#0072CE;color:#fff; font-size:13px;">
                        <th style="padding:6px; text-align:left;">ID</th>
                        <th style="padding:6px; text-align:left;">Name</th>
                        <th style="padding:6px; text-align:left;">Phone</th>
                        <th style="padding:6px; text-align:left;">Region</th>
                        <th style="padding:6px; text-align:left;">District</th>
                        <th style="padding:6px; text-align:left;">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($u = $assignedUsers->fetch_assoc()): ?>
                    <tr style="border-bottom:1px solid #ddd;">
                        <td style="padding:4px; text-align:left;"><?= $u['id'] ?></td>
                        <td style="padding:4px; text-align:left;"><?= htmlspecialchars($u['full_name'] ?? '') ?></td>
                        <td style="padding:4px; text-align:left;"><?= htmlspecialchars($u['phone'] ?? '') ?></td>
                        <td style="padding:4px; text-align:left;"><?= htmlspecialchars($u['region'] ?? '') ?></td>
                        <td style="padding:4px; text-align:left;"><?= htmlspecialchars($u['district'] ?? '') ?></td>
                        <td style="padding:4px; text-align:left;">
                            <a href="callcenter_edit_user.php?id=<?= $u['id'] ?>" 
                               style="background:#FFB400;color:#002147;padding:4px 8px;border-radius:4px;text-decoration:none;font-size:12px;">Edit</a>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div> <!-- end content -->

<?php include 'layout_end.php'; ?>
