<?php
// view_users.php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require_once "config.php";

// Protect agent access
if (!isset($_SESSION['agent_id'])) {
    header("Location: login.php");
    exit;
}

$agent_id = $_SESSION['agent_id'];

// Search
$search = $_GET['search'] ?? '';
$search_sql = '';
$params = [$agent_id];
$types = 'i'; // agent_id

if (!empty($search)) {
    $search_sql = " AND (full_name LIKE ? OR phone LIKE ? OR community LIKE ?) ";
    $like = "%$search%";
    $params[] = $like;
    $params[] = $like;
    $params[] = $like;
    $types .= 'sss';
}

// Pagination
$limit = 50;
$page = max(1, (int)($_GET['page'] ?? 1));
$offset = ($page - 1) * $limit;

// Add limit and offset to params
$types .= 'ii';
$params[] = $limit;
$params[] = $offset;

// Build query
$sql = "SELECT * FROM users WHERE assigned_agent_id = ? $search_sql ORDER BY date_registered DESC LIMIT ? OFFSET ?";
$stmt = $conn->prepare($sql);

// Bind dynamically
$bind_names[] = $types;
foreach ($params as $i => $param) {
    $bind_name = 'bind' . $i;
    $$bind_name = $param;
    $bind_names[] = &$$bind_name;
}
call_user_func_array([$stmt, 'bind_param'], $bind_names);

$stmt->execute();
$result = $stmt->get_result();

include("template.php");
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Registered Users - Agent Portal</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

</head>
<body>

<div class="card">
<h2>My Onboarded Users</h2>

<form method="GET">
    <input type="text" name="search" placeholder="Search by name, phone, community" value="<?=htmlspecialchars($search)?>">
    <button type="submit">Search</button>
</form>

<div class="table-responsive">
<table class="users-table">
<tr>
    <th>#</th><th>Name</th><th>Phone</th><th>Email</th><th>Network</th><th>Region</th><th>District</th><th>Community</th><th>Date Registered</th>
</tr>
<?php
$i = $offset + 1;
while($row = $result->fetch_assoc()){
    echo "<tr>
        <td data-label='#'>{$i}</td>
        <td data-label='Name'>{$row['full_name']}</td>
        <td data-label='Phone'>{$row['phone']}</td>
        <td data-label='Email'>{$row['email']}</td>
        <td data-label='Network'>{$row['network']}</td>
        <td data-label='Region'>{$row['region']}</td>
        <td data-label='District'>{$row['district']}</td>
        <td data-label='Community'>{$row['community']}</td>
        <td data-label='Date Registered'>{$row['date_registered']}</td>
    </tr>";
    $i++;
}
?>
</table>
</div>
</div>

<!-- Floating Action Buttons -->
<div class="fab-container">
    <a href="onboard_user.php" class="fab" title="Add User">+</a>
    <a href="export_users.php" class="fab" title="Export CSV">&#8681;</a>
</div>

</body>
</html>
