<?php
// session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit();
}

// Session timeout 30 mins
$timeout_duration = 1800;
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity']) > $timeout_duration) {
    session_unset();
    session_destroy();
    header("Location: login.php?message=Session expired. Please login again.");
    exit();
}
$_SESSION['last_activity'] = time();

$agent_name = $_SESSION['agent_name'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?= $page_title ?? "Agent Dashboard" ?> - 3y3 Supa</title>
<!-- Google Fonts for lively feel -->
<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
<style>
/* Global */
* { box-sizing: border-box; }
body { font-family: 'Roboto', Arial, sans-serif; background: #f0f2f5; margin:0; padding:0; }

/* Header */
header {
    background: #00539f;
    color: #fff;
    padding: 20px;
    text-align: center;
    font-size: 24px;
    font-weight: bold;
    box-shadow: 0 4px 6px rgba(0,0,0,0.2);
}

/* Navigation */
nav {
    background: #FFD700;
    padding: 10px;
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
    gap: 10px;
}
nav a {
    padding: 10px 15px;
    background: #00539f;
    color: #fff;
    text-decoration: none;
    border-radius: 8px;
    font-weight: bold;
    transition: 0.3s;
}
nav a:hover { background: #003f7f; transform: scale(1.05); }

/* Container / Card */
.container, .card {
    max-width: 1200px;
    margin: 20px auto;
    padding: 20px;
    background: #fff;
    border-radius: 15px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}
.card:hover { box-shadow: 0 6px 20px rgba(0,0,0,0.2); }

h2 { color: #00539f; margin-bottom: 15px; }

/* Form Inputs */
input[type=text], select, textarea {
    width: 100%;
    max-width: 400px;
    padding: 10px;
    margin: 5px 0 15px 0;
    border-radius: 8px;
    border: 1px solid #ccc;
    transition: 0.3s;
}
input:focus, select:focus, textarea:focus {
    border-color: #00539f;
    outline: none;
    box-shadow: 0 0 5px rgba(0,83,159,0.3);
}

/* Buttons */
button, form button {
    padding: 12px 20px;
    background: #00539f;
    color: #fff;
    border: none;
    border-radius: 8px;
    font-weight: bold;
    cursor: pointer;
    transition: 0.3s;
}
button:hover, form button:hover { background: #003f7f; transform: scale(1.05); }

/* Table */
.table-responsive {
    width: 100%;
    overflow-x: auto;
    margin-top: 15px;
}
.users-table {
    width: 100%;
    border-collapse: collapse;
    font-size: 0.85rem;
}
.users-table th, .users-table td {
    padding: 8px 10px;
    text-align: left;
    border: 1px solid #ccc;
}
.users-table th {
    background-color: #00539f;
    color: #fff;
}
.users-table tr:nth-child(even) { background-color: #f2f2f2; }

/* Floating Action Buttons */
.fab-container {
    position: fixed;
    bottom: 25px;
    right: 25px;
    display: flex;
    flex-direction: column;
    gap: 10px;
}
.fab {
    background-color: #00539f;
    color: #fff;
    border-radius: 50%;
    width: 55px;
    height: 55px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
    text-decoration: none;
    box-shadow: 0 2px 6px rgba(0,0,0,0.3);
    transition: background 0.3s;
}
.fab:hover { background-color: #003f7f; }

/* Responsive */
@media(max-width:768px){
    .container, .card { padding: 15px; }
    nav a { flex: 1 1 100%; text-align: center; }
    .users-table th, .users-table td { font-size: 14px; }
}
</style>


</head>
<body>

<header>3y3 Supa - Agent Portal</header>

<nav>
    <a href="index.php">Dashboard</a>
    <a href="onboard_user.php">Onboard User</a>
    <a href="view_users.php">View Users</a>
    <a href="logout.php">Logout</a>
</nav>

<div class="container">
<!-- Page content starts here -->
