<?php
require 'config.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

$keyword = trim($_POST['keyword'] ?? '');
if ($keyword === '') exit();

$q = '%' . $keyword . '%';

$stmt = $conn->prepare("
    SELECT 
        id,
        full_name,
        phone,
        ssnit_number,
        ghana_card,
        gender,
        region,
        district,
        community,
        gps_address,
        balance,
        status
    FROM users
    WHERE status = 'active'
      AND (
            full_name LIKE ?
         OR phone LIKE ?
         OR ssnit_number LIKE ?
         OR ghana_card LIKE ?
      )
    ORDER BY full_name ASC
    LIMIT 10
");

$stmt->bind_param("ssss", $q, $q, $q, $q);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo '<div class="list-group-item">No contributor found.</div>';
    exit;
}

while ($u = $result->fetch_assoc()) {

    // Replace nulls with empty strings
    $full_name   = htmlspecialchars($u['full_name'] ?? '');
    $phone       = htmlspecialchars($u['phone'] ?? '');
    $ssnit       = htmlspecialchars($u['ssnit_number'] ?? '');
    $ghana_card  = htmlspecialchars($u['ghana_card'] ?? '');
    $gender      = htmlspecialchars($u['gender'] ?? '');
    $community   = htmlspecialchars($u['community'] ?? '');
    $district    = htmlspecialchars($u['district'] ?? '');
    $region      = htmlspecialchars($u['region'] ?? '');
    $gps_address = htmlspecialchars($u['gps_address'] ?? '');
    $balance     = htmlspecialchars($u['balance'] ?? 0);

    $location = trim("$community $district $region");

    echo '
    <a href="#" class="list-group-item list-group-item-action select-contributor"
       data-id="'.(int)$u['id'].'"
       data-name="'.$full_name.'"
       data-phone="'.$phone.'"
       data-ssnit="'.$ssnit.'"
       data-gender="'.$gender.'"
       data-location="'.htmlspecialchars($location).'"
       data-gps="'.$gps_address.'"
       data-balance="'.$balance.'">
       <b>'.$full_name.'</b><br>
       <small class="text-muted">'.$phone.' | SSNIT: '.$ssnit.'</small>
    </a>';
}
