<?php
// var_dump($_POST);
// exit;
session_start();
require_once "config.php";
// require_once "../send_sms.php"; // send_sms($phone,$msg)
date_default_timezone_set('Africa/Accra');

if (!isset($_SESSION['agent_id'])) {
    die("Access denied");
}

echo $_SESSION['agent_id'];
exit;

function normalize_ghana_phone($phone){
    $phone = preg_replace('/[^0-9]/','',$phone);
    if(strlen($phone)==10 && substr($phone,0,1)=='0') return '233'.substr($phone,1);
    if(strlen($phone)==9) return '233'.$phone;
    if(strlen($phone)==12 && substr($phone,0,3)=='233') return $phone;
    return false;
}

if($_SERVER['REQUEST_METHOD']=='POST'){
    $full_name = trim($_POST['full_name']);
    $phone = normalize_ghana_phone($_POST['phone']);
    $email = trim($_POST['email']);
    $network = trim($_POST['network']);
    $region = trim($_POST['region']);
    $district = trim($_POST['district']);
    $community = trim($_POST['community']);

    $errors = [];

    if(!$full_name) $errors[] = "Full name is required";
    if(!$phone) $errors[] = "Invalid phone number";
    if(!$network) $errors[] = "Network is required";
    if(!$region) $errors[] = "Region is required";
    if(!$district) $errors[] = "District is required";
    if(!$community) $errors[] = "Community is required";

    // Check if phone exists
    $stmt = $conn->prepare("SELECT id FROM users WHERE phone=? LIMIT 1");
    $stmt->bind_param("s",$phone);
    $stmt->execute();
    $stmt->store_result();
    if($stmt->num_rows>0) $errors[] = "Phone already registered";
    $stmt->close();

    if(!empty($errors)){
        $_SESSION['message'] = implode("<br>",$errors);
        header("Location: onboard_user.php");
        exit();
    }

    // Generate 4-digit PIN
    $pin_plain = rand(1000,9999);
    $pin_hashed = password_hash($pin_plain,PASSWORD_DEFAULT);

    // Insert user
  $stmt = $conn->prepare("INSERT INTO users 
    (full_name, phone, email, network, region, district, community, assigned_agent_id, pin, date_registered)
    VALUES (?,?,?,?,?,?,?,?,?,NOW())");
$stmt->bind_param("sssssssis",$full_name,$phone,$email,$network,$region,$district,$community,$_SESSION['agent_id'],$pin_hashed);

    if($stmt->execute()){
        // Send SMS
        $loginLink="https://tuliyapayinc.com/edwumasupa/mobile/login.php";
        $smsMsg="Welcome $full_name to 3y3 Supa!\nLogin with phone: $phone and PIN: $pin_plain\nPortal: $loginLink";
        send_sms($phone,$smsMsg);

        $_SESSION['success'] = "User registered successfully! SMS sent to $phone";
        header("Location: onboard_user.php");
        exit();
    } else {
        $_SESSION['message'] = "DB error: ".$stmt->error;
        header("Location: onboard_user.php");
        exit();
    }
    $stmt->close();
}
