<?php
session_start();
$page_title = "Onboard User";
require 'template.php';

// Display errors or success messages passed via session
if (isset($_SESSION['message'])) {
    echo "<div class='card' style='background:#ffefef;color:#900;font-weight:bold;'>{$_SESSION['message']}</div>";
    unset($_SESSION['message']);
}
if (isset($_SESSION['success'])) {
    echo "<div class='card' style='background:#e6ffed;color:#080;font-weight:bold;'>{$_SESSION['success']}</div>";
    unset($_SESSION['success']);
}
?>
<style>
    .form-row {
  display: flex;
  gap: 20px;
  flex-wrap: wrap;
}

.form-group {
  flex: 1;
  min-width: 250px;
  display: flex;
  flex-direction: column;
}

label { font-weight: bold; margin-bottom: 5px; }

/* Responsive: single column on small screens */
@media (max-width: 768px) {
  .form-row { flex-direction: column; gap: 10px; }
  .form-group { min-width: 100%; }
}

</style>
<div class="card">
  <h2>Onboard New User</h2>
  <?php if(isset($_SESSION['message'])) { 
      echo "<p style='color:red'>".$_SESSION['message']."</p>"; 
      unset($_SESSION['message']); 
  } ?>
  <?php if(isset($_SESSION['success'])) { 
      echo "<p style='color:green'>".$_SESSION['success']."</p>"; 
      unset($_SESSION['success']); 
  } ?>

  <form method="POST" action="process_onboard.php">
  <div class="form-row">
    <div class="form-group">
      <label>Full Name</label>
      <input type="text" name="full_name" required>
    </div>
    <div class="form-group">
      <label>Phone</label>
        <input type="text" name="phone" required placeholder="e.g., 0244XXXXXX">
    </div>
  </div>

  <div class="form-row">
    <div class="form-group">
      <label>Email</label>
      <input type="text" name="email">
    </div>
   <div class="form-group">
          <label>Network</label>
    <select name="network" required>
        <option value="">--Select--</option>
        <option value="MTN">MTN</option>
        <option value="Vodafone">Vodafone</option>
        <option value="AirtelTigo">AirtelTigo</option>
    </select>
      </div>
    </div>

  <div class="form-row">
    <div class="form-group">
      <label>Region</label>
      <select name="region" id="region" required>
        <option value="">Select Region</option>
        <?php
        include('config.php');
        $regions = $conn->query("SELECT id, name FROM regions ORDER BY name");
        while($r = $regions->fetch_assoc()){
            echo "<option value='{$r['id']}'>{$r['name']}</option>";
        }
        ?>
      </select>
    </div>
    <div class="form-group">
      <label>District</label>
      <select name="district" id="district" required>
        <option value="">Select District</option>
      </select>
    </div>
  </div>

  <div class="form-row">
    <div class="form-group">
      <label>Community</label>
      <select name="community" id="community" required>
        <option value="">Select Community</option>
      </select>
    </div>
    <div class="form-group"></div>
  </div>

  <button type="submit">Register User</button>
</form>
</div>


<!-- Page content ends here -->
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function(){
    // When region changes, load districts
    $('#region').change(function(){
        var region_id = $(this).val();
        $('#district').html('<option>Loading...</option>');
        $('#community').html('<option>Select Community</option>');

        if(region_id){
            $.get('get_districts.php', {region_id: region_id}, function(data){
                $('#district').html(data);
            });
        } else {
            $('#district').html('<option>Select District</option>');
        }
    });

    // When district changes, load communities
    $('#district').change(function(){
        var district_id = $(this).val();
        $('#community').html('<option>Loading...</option>');

        if(district_id){
            $.get('get_communities.php', {district_id: district_id}, function(data){
                $('#community').html(data);
            });
        } else {
            $('#community').html('<option>Select Community</option>');
        }
    });
});
</script>

</body>
</html>