<?php
session_start();
require_once "../config.php"; // adjust path if needed

$error_msg = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = trim($_POST['password'] ?? '');

    if (empty($username) || empty($password)) {
        $error_msg = "Username and password required";
    } else {
        // Check agent in DB
        $stmt = $conn->prepare("SELECT id, full_name, password FROM agents WHERE username=? LIMIT 1");
        $stmt->bind_param("s",$username);
        $stmt->execute();
        $stmt->store_result();
        if ($stmt->num_rows === 1) {
            $stmt->bind_result($id, $fullname, $hashed_password);
            $stmt->fetch();

            if (password_verify($password, $hashed_password)) {
                // Login success
                $_SESSION['agent_id'] = $id;
                $_SESSION['agent_name'] = $fullname;
                $_SESSION['logged_in'] = true;
                header("Location: index.php");
                exit;
            } else {
                $error_msg = "Invalid password";
            }
        } else {
            $error_msg = "Agent not found";
        }
        $stmt->close();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Agent Login - 3y3 Supa</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
body{font-family:Arial,sans-serif;background:#f0f0f0;padding:20px;}
.container{max-width:400px;margin:auto;background:#fff;padding:20px;border-radius:10px;box-shadow:0 0 10px rgba(0,0,0,0.1);}
h2{text-align:center;margin-bottom:20px;color:#008000;}
form label{display:block;margin-top:10px;font-weight:bold;color:#333;}
form input{width:100%;padding:10px;margin-top:5px;border-radius:5px;border:1px solid #ccc;}
form button{margin-top:20px;width:100%;padding:12px;background:#008000;color:#fff;font-size:16px;border:none;border-radius:5px;font-weight:bold;cursor:pointer;}
form button:hover{background:#006400;}
.error{background:#f8d7da;color:#721c24;padding:10px;border-radius:5px;margin-bottom:15px;text-align:center;}
a.back{display:inline-block;margin-top:10px;padding:8px 12px;background:#FFD700;color:#000;text-decoration:none;border-radius:5px;font-weight:bold;}
a.back:hover{background:#FFC107;}
</style>
</head>
<body>
<div class="container">
<h2>Agent Login</h2>

<?php if($error_msg){ ?>
<div class="error"><?= $error_msg ?></div>
<?php } ?>

<form method="POST">
    <label>Username</label>
    <input type="text" name="username" required>

    <label>Password</label>
    <input type="password" name="password" required>

    <button type="submit">Login</button>
</form>

<a href="../index.php" class="back">Back to Main Site</a>
</div>
</body>
</html>
