<?php
if (!isset($_SESSION)) { session_start(); }

$agent_name = $_SESSION['agent_name'] ?? "Agent";
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Agent Panel</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

<style>
    body {
        background: #f4f6f9;
        font-family: Arial, sans-serif;
    }
    /* Sidebar */
    .sidebar {
        height: 100vh;
        width: 250px;
        position: fixed;
        left: 0;
        top: 0;
        background: #0d6efd;
        padding-top: 25px;
        color: white;
    }
    .sidebar h4 {
        text-align: center;
        margin-bottom: 30px;
        font-weight: 700;
    }
    .sidebar a {
        display: block;
        padding: 12px 20px;
        color: white;
        text-decoration: none;
        font-size: 15px;
    }
    .sidebar a:hover {
        background: rgba(255, 255, 255, 0.2);
    }
    .sidebar .active {
        background: rgba(255, 255, 255, 0.25);
    }

    /* Main Content */
    .content-area {
        margin-left: 250px;
        padding: 25px;
    }

    /* Top Bar */
    .topbar {
        height: 58px;
        background: white;
        padding: 10px 20px;
        border-bottom: 1px solid #dee2e6;
    }
</style>

</head>
<body>

<!-- Sidebar -->
<div class="sidebar">
    <h4>Agent Panel</h4>

    <a href="agent_dashboard.php" class="<?= ($active ?? '')=='dashboard' ? 'active' : '' ?>">
        <i class="fa fa-home"></i> Dashboard
    </a>

    <a href="agent_onboard.php" class="<?= ($active ?? '')=='onboard' ? 'active' : '' ?>">
        <i class="fa fa-user-plus"></i> Onboard Contributor
    </a>

    <a href="collect_payment.php" class="<?= ($active ?? '')=='collect' ? 'active' : '' ?>">
        <i class="fa fa-coins"></i> Collect Contributions
    </a>

    <a href="agent_contributors.php" class="<?= ($active ?? '')=='contributors' ? 'active' : '' ?>">
        <i class="fa fa-users"></i> All Contributors
    </a>

    <a href="agent_transactions.php" class="<?= ($active ?? '')=='transactions' ? 'active' : '' ?>">
        <i class="fa fa-money-bill"></i> Transactions
    </a>

    <a href="agent_profile.php" class="<?= ($active ?? '')=='profile' ? 'active' : '' ?>">
        <i class="fa fa-user"></i> Profile
    </a>

    <a href="logout.php">
        <i class="fa fa-sign-out-alt"></i> Logout
    </a>
</div>

<!-- MAIN CONTENT START -->
<div class="content-area">
    <div class="topbar d-flex justify-content-between align-items-center mb-3">
        <h5 class="m-0 fw-bold">Welcome, <?= htmlspecialchars($agent_name) ?></h5>
    </div>
