<?php
session_start();
if (!isset($_SESSION['agent_name']) || !isset($_SESSION['agent_id'])) {
    header("Location: login.php");
    exit();
}

$active = 'collect';
$agent_name = $_SESSION['agent_name'];
$agent_id = $_SESSION['agent_id'];

include 'includes/header_agent.php';
?>

<div class="container-fluid">

    <h4 class="fw-bold mb-4">Collect Contribution</h4>

    <!-- SUCCESS / ERROR MESSAGES -->
    <?php
    if (isset($_SESSION['success'])) {
        echo '<div class="alert alert-success alert-dismissible fade show" role="alert">'
             .htmlspecialchars($_SESSION['success']).
             '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
             </div>';
        unset($_SESSION['success']);
    }
    if (isset($_SESSION['error'])) {
        echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">'
             .htmlspecialchars($_SESSION['error']).
             '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
             </div>';
        unset($_SESSION['error']);
    }
    ?>

    <!-- STEP 1: SEARCH CONTRIBUTOR -->
    <div class="card mb-4 shadow-sm">
        <div class="card-body">
            <label class="form-label fw-bold">Search Contributor</label>
            <input type="text" id="searchContributor" class="form-control"
                   placeholder="Name / Phone / SSNIT / Ghana Card">
            <div id="searchList" class="list-group mt-2"></div>
        </div>
    </div>

    <!-- STEP 2: CONFIRM CONTRIBUTOR -->
    <div class="card mb-4 shadow-sm d-none" id="confirmCard">
        <div class="card-body">
            <h6 class="fw-bold text-success mb-3">
                <i class="fa fa-check-circle"></i> Confirm Contributor
            </h6>

            <div class="row">
                <div class="col-md-6">
                    <p><b>Name:</b> <span id="c_name"></span></p>
                    <p><b>Phone:</b> <span id="c_phone"></span></p>
                    <p><b>SSNIT / Ghana Card:</b> <span id="c_ssnit"></span></p>
                </div>
                <div class="col-md-6">
                    <p><b>Location:</b> <span id="c_location"></span></p>
                    <p><b>Gender:</b> <span id="c_gender"></span></p>
                    <p><b>Balance:</b> ₵<span id="c_balance"></span></p>
                </div>
            </div>

            <button class="btn btn-primary" id="confirmBtn">
                <i class="fa fa-thumbs-up"></i> Confirm Contributor
            </button>
        </div>
    </div>

    <!-- STEP 3: PAYMENT FORM -->
    <div class="card shadow-sm d-none" id="paymentCard">
        <div class="card-body">
            <form action="collect_payment_save.php" method="POST" id="paymentForm">
                <input type="hidden" name="user_id" id="contributor_id">

                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">Amount (₵)</label>
                        <input type="number" name="amount" class="form-control" required>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Payment Method</label>
                        <select name="payment_method" class="form-select">
                            <option value="Cash">Cash</option>
                            <option value="MoMo">Mobile Money</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Notes</label>
                        <input type="text" name="notes" class="form-control">
                    </div>
                </div>

                <div class="mt-4 text-end">
                    <button type="submit" class="btn btn-success px-4">
                        <i class="fa fa-coins"></i> Add Payment
                    </button>
                </div>
            </form>
        </div>
    </div>

</div> <!-- container-fluid -->

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script>
$(document).ready(function(){

    // ======= SEARCH CONTRIBUTORS =======
    $("#searchContributor").on("keyup", function () {
        let q = $(this).val();
        if (q.length < 2) return $("#searchList").html("");

        $.post("search_contributor.php", { keyword: q }, function (data) {
            $("#searchList").html(data);
        });
    });

    // ======= SELECT CONTRIBUTOR =======
    $(document).on("click", ".select-contributor", function (e) {
        e.preventDefault();

        $("#c_name").text($(this).data("name") || '');
        $("#c_phone").text($(this).data("phone") || '');
        $("#c_ssnit").text($(this).data("ssnit") || '');
        $("#c_location").text($(this).data("location") || '');
        $("#c_gender").text($(this).data("gender") || '');
        $("#c_balance").text($(this).data("balance") || '0.00');

        $("#contributor_id").val($(this).data("id"));

        $("#confirmCard").removeClass("d-none");
        $("#paymentCard").addClass("d-none");
        $("#searchList").html("");
    });

    // ======= CONFIRM CONTRIBUTOR =======
    $("#confirmBtn").on("click", function () {
        $("#paymentCard").removeClass("d-none");
        $(this).prop("disabled", true).text("Confirmed");
    });

    // ======= RESET FORM AFTER SUCCESS =======
    <?php if (isset($_SESSION['success'])): ?>
    $("#confirmCard, #paymentCard").addClass("d-none");
    $("#searchContributor").val("");
    $("#contributor_id").val("");
    $("#c_name, #c_phone, #c_ssnit, #c_location, #c_gender, #c_balance").text("");
    <?php endif; ?>

});
</script>

</body>
</html>
