<?php
session_start();

// Security check
if (!isset($_SESSION['agent_name'])) {
    header("Location: login.php");
    exit();
}

$active = 'onboard'; // highlights sidebar
include 'includes/header_agent.php';
?>

<div class="container-fluid">

    <!-- Page Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold">Onboard New Contributor</h4>
        <a href="agent_dashboard.php" class="btn btn-secondary btn-sm">
            <i class="fa fa-arrow-left"></i> Back to Dashboard
        </a>
    </div>

    <!-- Onboarding Form -->
    <div class="card shadow-sm">
        <div class="card-body">

            <form action="agent_onboard_save.php" method="POST">

                <div class="row g-3">

                    <!-- Full Name -->
                    <div class="col-md-6">
                        <label class="form-label">Full Name</label>
                        <input type="text" name="full_name" class="form-control" required>
                    </div>

                    <!-- Phone -->
                    <div class="col-md-6">
                        <label class="form-label">Phone Number</label>
                        <input type="text" name="phone" class="form-control" placeholder="024xxxxxxx" required>
                    </div>

                    <!-- Gender -->
                    <div class="col-md-4">
                        <label class="form-label">Gender</label>
                        <select name="gender" class="form-select" required>
                            <option value="">Select</option>
                            <option>Male</option>
                            <option>Female</option>
                        </select>
                    </div>

                    <!-- Date of Birth -->
                    <div class="col-md-4">
                        <label class="form-label">Date of Birth</label>
                        <input type="date" name="dob" class="form-control" required>
                    </div>

                    <!-- ID Type -->
                    <div class="col-md-4">
                        <label class="form-label">ID Type</label>
                        <select name="id_type" class="form-select">
                            <option>Ghana Card</option>
                            <option>Voter ID</option>
                            <option>Passport</option>
                        </select>
                    </div>

                    <!-- ID Number -->
                    <div class="col-md-6">
                        <label class="form-label">ID Number</label>
                        <input type="text" name="id_number" class="form-control">
                    </div>

                    <!-- Location -->
                    <div class="col-md-6">
                        <label class="form-label">Location / Area</label>
                        <input type="text" name="location" class="form-control" placeholder="e.g. Madina Zongo">
                    </div>

                    <!-- SSNIT / Mobex -->
                    <div class="col-md-6">
                        <label class="form-label">SSNIT / Mobex ID (if any)</label>
                        <input type="text" name="ssnit_number" class="form-control">
                    </div>

                    <!-- Initial Contribution -->
                    <div class="col-md-6">
                        <label class="form-label">Initial Contribution (₵)</label>
                        <input type="number" name="initial_amount" class="form-control">
                    </div>

                </div>

                <!-- Submit -->
                <div class="mt-4 text-end">
                    <button type="submit" class="btn btn-primary px-4">
                        <i class="fa fa-save"></i> Save Contributor
                    </button>
                </div>

            </form>

        </div>
    </div>

</div>

</div> <!-- content-area -->
</body>
</html>
