<?php
session_start();

// Agent must be logged in
// if (!isset($_SESSION['logged_in']) || $_SESSION['role'] !== 'agent') {
//     header("Location: login.php");
//     exit();
// }

$agent_name  = $_SESSION['agent_name'];
// $assigned_group = $_SESSION['group_name'];
include('includes/header_agent.php');
?>
<div class="agent-content">


<div class="container py-4">

    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3 class="fw-bold">Agent Dashboard</h3>
        <div>
            <span class="me-3 text-secondary">Hello, <b><?php echo $agent_name; ?></b></span>
            <a href="logout.php" class="btn btn-danger btn-sm">Logout</a>
        </div>
    </div>

    <!-- Assigned Group -->
    <div class="alert alert-primary">
        <i class="fa fa-map-marker-alt"></i> Assigned Group: 
        <b><?php echo $assigned_group; ?></b>
    </div>

    <!-- Summary Boxes -->
    <div class="row g-3 mb-4">

        <div class="col-6 col-md-3">
            <div class="card-box text-center">
                <i class="fa fa-user-plus summary-icon"></i>
                <div class="summary-value">22</div>
                <div class="summary-title">Onboarded Today</div>
            </div>
        </div>

        <div class="col-6 col-md-3">
            <div class="card-box text-center">
                <i class="fa fa-money-bill summary-icon"></i>
                <div class="summary-value">₵4,120</div>
                <div class="summary-title">Collections Today</div>
            </div>
        </div>

        <div class="col-6 col-md-3">
            <div class="card-box text-center">
                <i class="fa fa-users summary-icon"></i>
                <div class="summary-value">248</div>
                <div class="summary-title">Total Contributors</div>
            </div>
        </div>

        <div class="col-6 col-md-3">
            <div class="card-box text-center">
                <i class="fa fa-file-circle-check summary-icon"></i>
                <div class="summary-value">93%</div>
                <div class="summary-title">Reconciliation Rate</div>
            </div>
        </div>

    </div>

    <!-- Search Bar -->
    <div class="card mb-4">
        <div class="card-header bg-white fw-bold">Search Contributor</div>
        <div class="card-body search-box">
            <form id="searchForm">
                <input type="text" id="searchKeyword" class="form-control" placeholder="Enter Name, SSNIT Number, Mobex ID, or Phone">
            </form>
        </div>
    </div>

    <!-- Search Results -->
    <div class="card mb-4">
        <div class="card-header bg-white fw-bold">Results</div>
        <div class="card-body">
            <table class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>SSNIT&nbsp;/&nbsp;Mobex ID</th>
                        <th>Phone</th>
                        <th>Last Contribution</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody id="searchResults">
                    <!-- Filled by AJAX -->
                </tbody>
            </table>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="row g-3 mt-4">
        <div class="col-md-6">
            <a href="agent_onboard.php" class="btn btn-primary w-100 py-3">
                <i class="fa fa-user-plus"></i> Onboard New Contributor
            </a>
        </div>
        <div class="col-md-6">
            <a href="collect_payment.php" class="btn btn-success w-100 py-3">
                <i class="fa fa-coins"></i> Collect Contribution
            </a>
        </div>
    </div>

</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

<script>
/* AJAX Search Script */
$("#searchKeyword").on("keyup", function () {
    let keyword = $(this).val();

    if (keyword.length < 2) {
        $("#searchResults").html("");
        return;
    }

    $.post("search_contributor.php", { keyword: keyword }, function (data) {
        $("#searchResults").html(data);
    });
});
</script>
</div>

</body>
</html>
