<?php
session_start();
require_once '../config.php'; // DB connection & functions

$errors = [];
$success = '';

// Handle form submission
if(isset($_POST['register'])) {
    $fullname = trim($_POST['fullname']);
    $phone = trim($_POST['phone']);
    $password = trim($_POST['password']);
    $confirm_password = trim($_POST['confirm_password']);

    // Basic validation
    if(empty($fullname) || empty($phone) || empty($password) || empty($confirm_password)) {
        $errors[] = "All fields are required.";
    } elseif(!preg_match('/^\d{9,12}$/', $phone)) {
        $errors[] = "Invalid phone number format.";
    } elseif($password !== $confirm_password) {
        $errors[] = "Passwords do not match.";
    } else {
        // Check if phone already exists
        $stmt = $conn->prepare("SELECT id FROM users WHERE phone = ?");
        $stmt->bind_param("s", $phone);
        $stmt->execute();
        $stmt->store_result();
        if($stmt->num_rows > 0) {
            $errors[] = "Phone number already registered.";
        } else {
            // Hash password
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);

            // Insert user
            $stmt = $conn->prepare("INSERT INTO users (fullname, phone, password, created_at) VALUES (?, ?, ?, NOW())");
            $stmt->bind_param("sss", $fullname, $phone, $hashed_password);
            if($stmt->execute()) {
                $success = "Registration successful! You can now login.";
            } else {
                $errors[] = "Something went wrong. Try again.";
            }
        }
        $stmt->close();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>EdwumaSupa Registration</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<style>
* { box-sizing: border-box; }
body {
  margin: 0; padding: 0;
  font-family: 'Poppins', sans-serif;
  background: linear-gradient(135deg, #F58220 0%, #D85C00 100%);
  min-height: 100vh; display: flex;
  flex-direction: column; justify-content: center; align-items: center;
}
.login-container {
  background: #fff; border-radius: 16px; padding: 40px 30px;
  width: 100%; max-width: 400px; box-shadow: 0 8px 30px rgba(0,0,0,0.1);
}
.login-container h2 { color: #F58220; text-align: center; margin-bottom: 30px; }
.input-group { margin-bottom: 20px; }
.input-group label { display: block; font-weight: 600; margin-bottom: 5px; color: #000; }
.input-group input {
  width: 100%; padding: 12px 15px; border: 1px solid #ccc; border-radius: 10px; font-size: 16px;
}
.password-wrapper { position: relative; }
.toggle-password { position: absolute; right: 15px; top: 40px; font-size: 18px; cursor: pointer; color: #888; }
.toggle-password:hover { color: #F58220; }
.login-btn { width: 100%; padding: 14px; background: linear-gradient(135deg, #F58220 0%, #D85C00 100%);
  border: none; border-radius: 10px; color: #fff; font-weight: 700; font-size: 16px; cursor: pointer; transition: 0.3s; margin-bottom: 12px;
}
.login-btn:hover { opacity: 0.9; }
.extra-links { text-align: center; margin-top: 15px; }
.extra-links a { color: #F58220; text-decoration: none; font-size: 14px; margin: 0 5px; }
.extra-links a:hover { text-decoration: underline; }
.footer { margin-top: 25px; text-align: center; font-size: 13px; color: #fff; opacity: 0.9; }
.error { color: #ff6b6b; margin: 5px 0; }
.success { color: #4ade80; margin: 5px 0; }
</style>
</head>
<body>

<div class="login-container">
  <h2>Register</h2>

  <?php foreach($errors as $err) echo "<div class='error'>$err</div>"; ?>
  <?php if($success) echo "<div class='success'>$success</div>"; ?>

  <form method="post">
    <div class="input-group">
      <label for="fullname">Full Name</label>
      <input type="text" id="fullname" name="fullname" placeholder="Enter Full Name" required>
    </div>
    <div class="input-group">
      <label for="phone">Phone Number</label>
      <input type="text" id="phone" name="phone" placeholder="Enter Phone Number" required>
    </div>
    <div class="input-group password-wrapper">
      <label for="password">Password</label>
      <input type="password" id="password" name="password" placeholder="Enter Password" required>
      <i class="fa-solid fa-eye toggle-password" onclick="togglePassword()"></i>
    </div>
    <div class="input-group password-wrapper">
      <label for="confirm_password">Confirm Password</label>
      <input type="password" id="confirm_password" name="confirm_password" placeholder="Confirm Password" required>
      <i class="fa-solid fa-eye toggle-password" onclick="toggleConfirmPassword()"></i>
    </div>
    <button type="submit" name="register" class="login-btn">Register</button>
  </form>

  <div class="extra-links">
    <a href="login.php">Already have an account? Login</a>
  </div>
</div>

<div class="footer">
  © 2025 EdwumaSupa — Powered by Tekpulse Consult Ltd
</div>

<script>
function togglePassword() {
  const pass = document.getElementById("password");
  const icon = document.querySelectorAll(".toggle-password")[0];
  if(pass.type === "password"){ pass.type="text"; icon.classList.replace("fa-eye","fa-eye-slash"); }
  else{ pass.type="password"; icon.classList.replace("fa-eye-slash","fa-eye"); }
}
function toggleConfirmPassword() {
  const pass = document.getElementById("confirm_password");
  const icon = document.querySelectorAll(".toggle-password")[1];
  if(pass.type === "password"){ pass.type="text"; icon.classList.replace("fa-eye","fa-eye-slash"); }
  else{ pass.type="password"; icon.classList.replace("fa-eye-slash","fa-eye"); }
}
</script>

</body>
</html>
