<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once "config.php";

$success = "";
$error = "";

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = trim($_POST['full_name']);
    $phone = preg_replace('/[^0-9]/','',$_POST['phone']);
    $email = trim($_POST['email']);
    $network = trim($_POST['network']);
    $region = trim($_POST['region']);
    $district = trim($_POST['district']);
    $community = trim($_POST['community']);
    $occupation = trim($_POST['occupation']);
    $work_category = trim($_POST['work_category']);

    // Minimal validation
    if (!$full_name || !$phone || !$network || !$region || !$district || !$community) {
        $error = "Please fill all required fields.";
    } else {
        // Normalize Ghana phone
        if (strlen($phone) == 10 && substr($phone,0,1)=='0') $phone='233'.substr($phone,1);
        if (strlen($phone) == 9) $phone='233'.$phone;
        if (strlen($phone)!=12 || substr($phone,0,3)!='233') $error="Invalid phone number.";
    }

    // Check duplicates
    if (!$error) {
        $stmt = $conn->prepare("SELECT id FROM users WHERE phone=? LIMIT 1");
        $stmt->bind_param("s",$phone);
        $stmt->execute();
        $stmt->store_result();
        if ($stmt->num_rows>0) $error="Phone number already registered.";
        $stmt->close();
    }

    // Insert into DB
    if (!$error) {
        $pin_plain = str_pad(rand(0,9999),4,'0',STR_PAD_LEFT);
        $pin_hashed = password_hash($pin_plain,PASSWORD_DEFAULT);

        $stmt = $conn->prepare("INSERT INTO users 
            (full_name, phone, email, network, region, district, community, occupation, work_category, pin) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("ssssssssss",$full_name,$phone,$email,$network,$region,$district,$community,$occupation,$work_category,$pin_hashed);

        if ($stmt->execute()) {
            $success = "User registered successfully! PIN: $pin_plain";
            
            // Optional: Send SMS
            $loginLink="https://tuliyapayinc.com/edwumasupa/mobile/login.php";
            $smsMsg="Welcome $full_name to 3y3 Supa!\nLogin with phone: $phone and PIN: $pin_plain\nPortal: $loginLink";
            send_sms($phone,$smsMsg);

        } else {
            $error = "DB Error: ".$stmt->error;
        }
        $stmt->close();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Field Agent Onboarding - 3y3 Supa</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
body { font-family: Arial; background:#f7f7f7; padding:20px;}
.container { max-width:600px; margin:auto; background:#fff; padding:20px; border-radius:10px; box-shadow:0 0 10px rgba(0,0,0,0.1);}
h2 { text-align:center; margin-bottom:20px;}
input, select { width:100%; padding:12px; margin:6px 0; border-radius:5px; border:1px solid #ccc; font-size:16px;}
button { width:100%; padding:12px; margin-top:12px; background:#28a745; color:white; font-size:16px; border:none; border-radius:5px; cursor:pointer;}
button:hover { background:#218838;}
.success { background:#d4edda; color:#155724; padding:10px; border-radius:5px; margin-bottom:10px;}
.error { background:#f8d7da; color:#721c24; padding:10px; border-radius:5px; margin-bottom:10px;}
</style>
</head>
<body>
<div class="container">
<h2>Register New User</h2>

<?php if($success) echo "<div class='success'>$success</div>"; ?>
<?php if($error) echo "<div class='error'>$error</div>"; ?>

<form method="POST">
    <input type="text" name="full_name" placeholder="Full Name *" required>
    <input type="text" name="phone" placeholder="Phone Number *" required>
    <input type="email" name="email" placeholder="Email">
    <input type="text" name="network" placeholder="Network *" required>
    <input type="text" name="region" placeholder="Region *" required>
    <input type="text" name="district" placeholder="District *" required>
    <input type="text" name="community" placeholder="Community *" required>
    <input type="text" name="occupation" placeholder="Occupation">
    <input type="text" name="work_category" placeholder="Work Category">

    <button type="submit">Register User</button>
</form>
</div>

<!-- Page content ends here -->
</div>
</body>
</html>
