<?php
session_start();
require_once '../config.php';

$errors = [];
$success = '';
$showOtpInput = false;

// Handle Send OTP
if (isset($_POST['send_otp'])) {
    $phone = trim($_POST['phone']);

    if (empty($phone)) {
        $errors[] = "Phone number is required.";
    } elseif (!preg_match('/^\d{9,12}$/', $phone)) {
        $errors[] = "Invalid phone number format.";
    } else {
        $otp = rand(100000, 999999);
        $_SESSION['otp'] = $otp;
        $_SESSION['otp_phone'] = $phone;
        $_SESSION['otp_expiry'] = time() + 300; // 5 mins

        $smsResult = send_sms($phone, "Your OTP is: $otp");

        if ($smsResult) {
            $success = "OTP sent to $phone";
            $showOtpInput = true;
        } else {
            $errors[] = "Failed to send OTP. Try again.";
        }
    }
}

// Handle Verify OTP
if (isset($_POST['verify_otp'])) {
    $enteredOtp = trim($_POST['otp']);
    if (empty($enteredOtp)) {
        $errors[] = "Please enter OTP.";
    } elseif (!isset($_SESSION['otp']) || time() > $_SESSION['otp_expiry']) {
        $errors[] = "OTP expired. Please request a new one.";
    } elseif ($enteredOtp != $_SESSION['otp']) {
        $errors[] = "Incorrect OTP.";
    } else {
        $_SESSION['user_phone'] = $_SESSION['otp_phone'];
        unset($_SESSION['otp'], $_SESSION['otp_phone'], $_SESSION['otp_expiry']);
        header("Location: dashboard.php");
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>EdwumaSupa Login</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<style>
  * { box-sizing: border-box; }
  body {
    margin: 0; padding: 0;
    font-family: 'Poppins', sans-serif;
    background: linear-gradient(135deg, #F58220 0%, #D85C00 100%);
    min-height: 100vh; display: flex;
    flex-direction: column; justify-content: center; align-items: center;
  }
  .login-container {
    background: #fff; border-radius: 16px; padding: 40px 30px;
    width: 100%; max-width: 400px; box-shadow: 0 8px 30px rgba(0,0,0,0.1);
  }
  .login-container h2 { color: #F58220; text-align: center; margin-bottom: 30px; }
  .input-group { margin-bottom: 20px; }
  .input-group label { display: block; font-weight: 600; margin-bottom: 5px; color: #000; }
  .input-group input {
    width: 100%; padding: 12px 15px; border: 1px solid #ccc; border-radius: 10px; font-size: 16px;
  }
  .login-btn { width: 100%; padding: 14px; background: linear-gradient(135deg, #F58220 0%, #D85C00 100%);
    border: none; border-radius: 10px; color: #fff; font-weight: 700; font-size: 16px; cursor: pointer; transition: 0.3s; margin-bottom: 12px;
  }
  .login-btn:hover { opacity: 0.9; }
  .otp-btn { width: 100%; padding: 14px; background: #fff; border: 2px solid #F58220; color: #F58220;
    border-radius: 10px; font-weight: 700; font-size: 16px; cursor: pointer; transition: 0.3s; margin-bottom: 12px;
  }
  .otp-btn:hover { background: #F58220; color: #fff; }
  .extra-links { text-align: center; margin-top: 15px; }
  .extra-links a { color: #F58220; text-decoration: none; font-size: 14px; margin: 0 5px; }
  .extra-links a:hover { text-decoration: underline; }
  .footer { margin-top: 25px; text-align: center; font-size: 13px; color: #fff; opacity: 0.9; }
  .error { color: #ff6b6b; margin: 5px 0; }
  .success { color: #4ade80; margin: 5px 0; }
</style>
</head>
<body>

<div class="login-container">
  <h2>EdwumaSupa</h2>

  <?php foreach($errors as $err) echo "<div class='error'>$err</div>"; ?>
  <?php if($success) echo "<div class='success'>$success</div>"; ?>

  <!-- OTP Login Form -->
  <?php if(!$showOtpInput && !isset($_POST['verify_otp'])): ?>
  <form method="post">
    <div class="input-group">
      <label for="phone">Phone Number</label>
      <input type="text" id="phone" name="phone" placeholder="Enter Phone Number" required>
    </div>
    <button type="submit" name="send_otp" class="otp-btn">Send OTP</button>
  </form>
  <?php else: ?>
  <form method="post">
    <div class="input-group">
      <label for="otp">Enter OTP</label>
      <input type="text" id="otp" name="otp" placeholder="6-digit OTP" required>
    </div>
    <button type="submit" name="verify_otp" class="login-btn">Verify OTP</button>
  </form>
  <form method="post">
    <button type="submit" name="send_otp" class="otp-btn">Resend OTP</button>
  </form>
  <?php endif; ?>
</div>

<div class="footer">
  © 2025 EdwumaSupa — Powered by Tekpulse Consult Ltd
</div>

</body>
</html>
