<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>EdwumaSupa Login</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
  * { box-sizing: border-box; }

  body {
    margin: 0;
    padding: 0;
    font-family: 'Poppins', sans-serif;
    background: linear-gradient(135deg, #F58220 0%, #D85C00 100%);
    min-height: 100vh;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
  }

  .login-container {
    background: #fff;
    border-radius: 16px;
    padding: 40px 30px;
    width: 100%;
    max-width: 400px;
    box-shadow: 0 8px 30px rgba(0,0,0,0.1);
  }

  .login-container h2 {
    color: #F58220;
    text-align: center;
    margin-bottom: 30px;
  }

  .input-group {
    margin-bottom: 20px;
  }

  .input-group label {
    display: block;
    font-weight: 600;
    margin-bottom: 5px;
    color: #000;
  }

  .input-group input {
    width: 100%;
    padding: 12px 15px;
    border: 1px solid #ccc;
    border-radius: 10px;
    font-size: 16px;
  }

  /* PASSWORD EYE ICON */
  .password-wrapper { position: relative; }
  .toggle-password {
    position: absolute;
    right: 15px;
    top: 40px;
    font-size: 18px;
    cursor: pointer;
    color: #888;
  }
  .toggle-password:hover { color: #F58220; }

  .login-btn {
    width: 100%;
    padding: 14px;
    background: linear-gradient(135deg, #F58220 0%, #D85C00 100%);
    border: none;
    border-radius: 10px;
    color: #fff;
    font-weight: 700;
    font-size: 16px;
    cursor: pointer;
    transition: 0.3s;
    margin-bottom: 12px;
  }

  .login-btn:hover { opacity: 0.9; }

  /* OTP Login Button */
  .otp-btn {
    width: 100%;
    padding: 14px;
    background: #fff;
    border: 2px solid #F58220;
    color: #F58220;
    border-radius: 10px;
    font-weight: 700;
    font-size: 16px;
    cursor: pointer;
    transition: 0.3s;
  }

  .otp-btn:hover {
    background: #F58220;
    color: #fff;
  }

  .extra-links {
    text-align: center;
    margin-top: 15px;
  }

  .extra-links a {
    color: #F58220;
    text-decoration: none;
    font-size: 14px;
    margin: 0 5px;
  }

  .extra-links a:hover {
    text-decoration: underline;
  }

  .footer {
    margin-top: 25px;
    text-align: center;
    font-size: 13px;
    color: #fff;
    opacity: 0.9;
  }
</style>
</head>

<body>

<div class="login-container">
  <h2>EdwumaSupa</h2>

  <form action="login.php" method="POST">

    <!-- PHONE NUMBER INSTEAD OF GHANA CARD -->
    <div class="input-group">
      <label for="phone">Phone Number</label>
      <input type="text" id="phone" name="phone" placeholder="Enter Phone Number" required>
    </div>

    <div class="input-group password-wrapper">
      <label for="password">Password</label>
      <input type="password" id="password" name="password" placeholder="Enter Password" required>
      <i class="fa-solid fa-eye toggle-password" onclick="togglePassword()"></i>
    </div>

    <button type="submit" class="login-btn">Login</button>
  </form>

  <!-- LOGIN WITH OTP BUTTON -->
  <button class="otp-btn" onclick="window.location='login_otp.php'">
    Login with Mobile OTP
  </button>

  <div class="extra-links">
    <a href="#">Forgot Password?</a> | 
    <a href="register.php">Register</a>
  </div>
</div>

<div class="footer">
  © 2025 EdwumaSupa — Powered by Tekpulse Consult Ltd
</div>

<script>
function togglePassword() {
  const pass = document.getElementById("password");
  const icon = document.querySelector(".toggle-password");

  if (pass.type === "password") {
    pass.type = "text";
    icon.classList.replace("fa-eye", "fa-eye-slash");
  } else {
    pass.type = "password";
    icon.classList.replace("fa-eye-slash", "fa-eye");
  }
}
</script>

</body>
</html>
