<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>EdwumaS - Superannuation</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
<style>
/* Reset and body */
body {
    margin: 0;
    font-family: 'Poppins', sans-serif;
    background: #F9F9F9;
    color: #000;
    transition: margin-left 0.3s;
    overflow-x: hidden;
}

/* Header / Topbar */
header {
    background: linear-gradient(135deg, #F58220 0%, #D85C00 100%);
    padding: 20px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    color: #fff;
    position: fixed;
    width: 100%;
    top: 0;
    z-index: 1001;
}
header h1 { font-size: 18px; margin: 0; }
.hamburger { font-size: 22px; cursor: pointer; }

/* Sidebar */
.sidebar {
    position: fixed;
    top: 0;
    left: 0;
    width: 250px;
    height: 100%;
    background: #fff;
    box-shadow: 2px 0 12px rgba(0,0,0,0.1);
    padding: 20px;
    transition: transform 0.3s ease;
    z-index: 1000;
    transform: translateX(-100%);
}
.sidebar.active { transform: translateX(0); }
.sidebar h2 { color: #D85C00; margin-bottom: 20px; }
.sidebar ul { list-style: none; padding: 0; margin: 0; }
.sidebar ul li { padding: 12px 0; border-bottom: 1px solid #eee; cursor: pointer; }
.sidebar ul li:hover { color: #F58220; }

/* Overlay */
.overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 0;
    height: 100%;
    background: rgba(0,0,0,0.4);
    transition: opacity 0.3s ease, width 0s linear 0.3s;
    opacity: 0;
    z-index: 999;
}
.overlay.active {
    width: 100%;
    opacity: 1;
    transition: opacity 0.3s ease;
}

/* Main container */
.container {
    padding: 100px 20px 20px 20px;
    transition: margin-left 0.3s;
}
.container.shift { margin-left: 250px; }

/* Cards grid */
.cards {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    gap: 20px;
    margin-bottom: 20px;
}
.card {
    background: #fff;
    border-radius: 16px;
    padding: 20px;
    text-align: center;
    box-shadow: 0 8px 25px rgba(0,0,0,0.08);
    cursor: pointer;
    transition: 0.3s;
}
.card:hover { transform: translateY(-5px); box-shadow: 0 12px 30px rgba(0,0,0,0.15); }
.card i { font-size: 30px; color: #F58220; margin-bottom: 10px; }
.card span { display: block; font-weight: 600; font-size: 16px; }

/* Sections */
.section h2 { font-size: 18px; margin-bottom: 15px; color: #D85C00; }
.contribution-list { list-style: none; padding: 0; margin: 0; }
.contribution-list li {
    background: #fff;
    margin-bottom: 10px;
    padding: 15px;
    border-radius: 12px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.05);
    display: flex;
    justify-content: space-between;
    font-size: 14px;
}

/* Responsive */
@media(max-width: 768px){
    .container.shift { margin-left: 0; }
    .card i { font-size: 24px; }
    .card span { font-size: 14px; }
}
</style>
</head>
<body>

<header>
    <div class="hamburger" onclick="toggleSidebar()"><i class="fa-solid fa-bars"></i></div>
    <div class="container-fluid">
     <!-- Right: User info + Logout -->
    <div style="display: flex; align-items: center; gap: 15px; color: #fff;">
      <?php //if ($user): ?>
        <span><i class="fa-solid fa-user"></i> Joachim Some</span>
        <a href="">&nbsp;&nbsp;</a>
      <?php //endif; ?>
    </div>
    </div>
</header>

<div class="sidebar" id="sidebar">
    <h2>Menu</h2>
    <ul>
        <li>Home</li>
        <li>Contribute</li>
        <li>My Balance</li>
        <li>History</li>
        <li>Pension Projection</li>
        <li>Beneficiaries</li>
        <li>Support</li>
        <li>Logout</li>
    </ul>
</div>

<div class="overlay" id="overlay" onclick="toggleSidebar()"></div>

<div class="container" id="container">

    <!-- Cards -->
    <div class="cards">
        <div class="card">
            <i class="fa-solid fa-hand-holding-dollar"></i>
            <span>Contribute</span>
        </div>
        <div class="card">
            <i class="fa-solid fa-wallet"></i>
            <span>Balance</span>
        </div>
        <div class="card">
            <i class="fa-solid fa-clock-rotate-left"></i>
            <span>History</span>
        </div>
        <div class="card">
            <i class="fa-solid fa-chart-line"></i>
            <span>Projection</span>
        </div>
        <div class="card">
            <i class="fa-solid fa-users"></i>
            <span>Beneficiaries</span>
        </div>
        <div class="card">
            <i class="fa-solid fa-headset"></i>
            <span>Support</span>
        </div>
    </div>

    <!-- Contributions list -->
    <div class="section">
        <h2>Recent Contributions</h2>
        <ul class="contribution-list">
            <li><span>₵ 50.00</span><span>Success</span></li>
            <li><span>₵ 30.00</span><span>Pending</span></li>
            <li><span>₵ 20.00</span><span>Failed</span></li>
            <li><span>₵ 100.00</span><span>Success</span></li>
        </ul>
    </div>

</div>

<script>
function toggleSidebar() {
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('overlay');
    const container = document.getElementById('container');
    
    sidebar.classList.toggle('active');
    overlay.classList.toggle('active');

    if(window.innerWidth > 768){
        container.classList.toggle('shift');
    }
}
</script>

</body>
</html>
