<?php
// ============================
// ERROR REPORTING
// ============================
error_reporting(E_ALL);
ini_set('display_errors', 1);

// ============================
// TIMEZONE
// ============================
date_default_timezone_set('Africa/Accra');

// ============================
// DATABASE CONFIGURATION
// ============================
define('DB_HOST', 'localhost');
define('DB_USER', 'tuliyapa_supa');
define('DB_PASS', 'akimshit1580');
define('DB_NAME', 'tuliyapa_edwumasupa_db');
define('DB_CHARSET', 'utf8mb4');

// Create database connection
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}
$conn->set_charset(DB_CHARSET);

// ============================
// SITE CONFIGURATION
// ============================
define('SITE_NAME', '3y3 Supa');
define('SITE_URL', 'https://tuliyapayinc.com/edwumasupa'); // Replace with your domain
define('ENVIRONMENT', 'development');         // development or production

// ============================
// API KEYS / INTEGRATIONS
// ============================

// Arkesel SMS
define('ARKESSEL_API_KEY', 'OmlmMERVeHJOdHhhT3BMUDQ=');
define('ARKESSEL_SENDER', 'Tekpulse');

// Hubtel Mobile Money API
define('HUBTEL_CLIENT_ID', 'your_hubtel_client_id');
define('HUBTEL_CLIENT_SECRET', 'your_hubtel_client_secret');
define('HUBTEL_ENV', 'sandbox'); // 'sandbox' or 'production'
define('HUBTEL_CALLBACK_URL', SITE_URL . '/hubtel_callback.php'); // webhook endpoint

// ============================
// GLOBAL CONSTANTS
// ============================
define('DEFAULT_PASSWORD', 'ChangeMe123!'); // default password for new users
define('ADMIN_EMAIL', 'admin@yourdomain.com');

// ============================
// HELPER FUNCTIONS
// ============================

/**
 * Escape input to prevent SQL Injection
 */
function escape($data) {
    global $conn;
    return $conn->real_escape_string(trim($data));
}

/**
 * Send SMS via Arkesel
 */
function send_sms($phone, $message) {
    if (substr($phone, 0, 1) === '0') {
        $phone = '233' . substr($phone, 1);
    }

    $arkeselUrl = "https://sms.arkesel.com/sms/api";
    $queryParams = http_build_query([
        "action" => "send-sms",
        "api_key" => ARKESSEL_API_KEY,
        "to" => $phone,
        "from" => ARKESSEL_SENDER,
        "sms" => $message
    ]);

    $ch = curl_init("$arkeselUrl?$queryParams");
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 10,
    ]);

    $response = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);

    if ($err) {
        error_log("send_sms error for $phone: $err");
    }

    return $response;
}

// ============================
// Hubtel Access Token Generator (Improved)
// ============================
function hubtel_get_access_token() {
    $url = HUBTEL_ENV === 'sandbox' 
        ? "https://sandboxapi.hubtel.com/v1/oauth/access_token" 
        : "https://api.hubtel.com/v1/oauth/access_token";

    $credentials = base64_encode(HUBTEL_CLIENT_ID . ":" . HUBTEL_CLIENT_SECRET);

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => "grant_type=client_credentials",
        CURLOPT_HTTPHEADER => [
            "Authorization: Basic $credentials",
            "Content-Type: application/x-www-form-urlencoded"
        ]
    ]);

    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        error_log("Hubtel OAuth error: " . curl_error($ch));
        curl_close($ch);
        return false;
    }
    curl_close($ch);

    $data = json_decode($response, true);
    if (isset($data['access_token'])) {
        return $data['access_token'];
    } else {
        error_log("Hubtel OAuth failed: " . $response);
        return false;
    }
}

// ============================
// Initiate Hubtel MoMo Payment (Improved)
// ============================
function hubtel_initiate_payment($phone, $amount, $reference, $description = "SPA_GIG Contribution") {
    $accessToken = hubtel_get_access_token();
    if (!$accessToken) return false;

    $url = HUBTEL_ENV === 'sandbox'
        ? "https://sandboxapi.hubtel.com/v1/merchantaccount/transactions/initiate"
        : "https://api.hubtel.com/v1/merchantaccount/transactions/initiate";

    $payload = [
        "Amount" => number_format($amount, 2, '.', ''),
        "PhoneNumber" => $phone,
        "Currency" => "GHS",
        "Reference" => $reference,
        "TransactionDesc" => $description,
        "CallbackUrl" => HUBTEL_CALLBACK_URL
    ];

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($payload),
        CURLOPT_HTTPHEADER => [
            "Authorization: Bearer $accessToken",
            "Content-Type: application/json"
        ]
    ]);

    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        error_log("Hubtel payment initiation error for $phone: " . curl_error($ch));
        curl_close($ch);
        return false;
    }
    curl_close($ch);

    $resp_data = json_decode($response, true);
    if (!$resp_data) {
        error_log("Hubtel payment initiation returned invalid response: $response");
    }

    return $resp_data ?: $response;
}

// ============================
// Optional: Log Hubtel API request
// ============================
function hubtel_log_request($phone, $amount, $reference, $response) {
    global $conn;
    $stmt = $conn->prepare("INSERT INTO api_logs (response, token, date_created, type) VALUES (?, ?, NOW(), 'PAYMENT_REQUEST')");
    $resp_json = json_encode($response, JSON_UNESCAPED_SLASHES);
    $stmt->bind_param("ss", $resp_json, $reference);
    $stmt->execute();
    $stmt->close();
}
